/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ENVELOPECONTROLLERWIDGET_H
#define ENVELOPECONTROLLERWIDGET_H

#include <qhbox.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qvbuttongroup.h>
#include "displayenvelopewidget.h"
#include "envelope.h"
#include "potentiometerwidget.h"


/**
@author Predrag Viceic
*/
class EnvelopeControllerWidget : public QHBox
{
Q_OBJECT
public:
    EnvelopeControllerWidget(QWidget *parent = 0, const char *name = 0);

    ~EnvelopeControllerWidget();
    void setInHolder(bool);
    long getEndFrame();
    long getStartFrame();
    EnvelopeData* getEnvData();
    QSize sizeHint () const;
protected:
    DisplayEnvelopeWidget* displayEnvelope;
    PotentiometerWidget* envDurationWidget;
    PotentiometerWidget* envResolutionWidget;
    EnvelopeData* envData;
    QPushButton* onoff;
    QButtonGroup* optionsBG;

    bool inHolder;
    long start_frame;
    long end_frame;
    int e_width;
signals:
    void envelopeChanged(EnvelopeData* envData);
public slots:
    void setData(QString envData);
    void setEndFrame(long ef);
    void setStartFrame(long sf);
    void durationChanged();
    void resolutionChanged();
    void endModeChanged(int btn);
    void onoffChanged(bool on);
    void envDataChanged();
};

#endif
