/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CUSTOMEFFECT_H
#define CUSTOMEFFECT_H

#include <qobject.h>
#include "defs.h"

/**
@author Predrag Viceic
*/
class CustomEffect : public QObject
{
Q_OBJECT
public:
    CustomEffect(QObject *parent = 0, const char *name = 0);

    ~CustomEffect();
    virtual void process(long length) = 0;
    virtual void init(long length) = 0;
    virtual void advancePosition(long length) = 0;
    virtual void setPosition(long position) = 0;
    int preOrPost();
    void setPre();
    void setPost();
    virtual QString getName() = 0;
    enum EffectPosition {POSITION_PRE,POSITION_POST,POSITION_PASS};

protected:
    long bufferLength;
    int preOrPostVal;
};

#endif
