################          START USER EDITABLE PART       ###############

# Comment this line if you don't have portmidi installed on your system
# You wont be able to play audio chunks via midi unles you have alsa(seq)
#DEFINES += HAS_PORTMIDI

# Comment this line if you don't have jack installed on your system
# Jack output won't be available, you will use alsa, portaudio or OSS
DEFINES += HAS_JACK

# Comment this line if you don't have alsa installed on your system
# Alsa output won't be available, you will use jack, portaudio or OSS
DEFINES += HAS_ALSA

# Comment this line if you don't have portaudio installed on your system
# Portaudio output won't be available, you will use alsa, jack or OSS
# Note: on Linux, Portaudio uses alsa.
#DEFINES += HAS_PORTAUDIO

# Comment this line if you don't have OSS installed on your system
# OSS output won't be available, you will use alsa, portaudio or jack
# This is mainly useful for non unix or OSX builds
#DEFINES += HAS_OSS

# Comment this line if you don't have libinstpatch installed on your system
# You won't be able to export sf2 files (nor future DLS and GIGA)
#DEFINES += HAS_LIBINSTPATCH

# Comment this line if you don't have aubio installed on your system
# The aubio beatmatching algorithms won't be available, only the freecycle ones.
DEFINES += HAS_AUBIO

# Comment this line if you don't have SoundTouch libs installed on your system
# You wont be able to timestretch audio, nor, in future, to pitchshift audio chunks
# This feature doesn't work well anyways..
DEFINES += HAS_SOUNDTOUCH

#You can add your own include paths here
INCLUDEPATH += /usr/include
INCLUDEPATH += /usr/local/include
INCLUDEPATH += /opt/gnome/include/glib-2.0
INCLUDEPATH += /usr/include/glib-2.0
INCLUDEPATH += /usr/lib/glib-2.0/include
INCLUDEPATH += /opt/gnome/lib/glib-2.0/include
INCLUDEPATH += /usr/include/libinstpatch-1.0

################          STATIC LINK SETTINGS       ###############

# Uncomment this line if you want to link Freecycle statically
# You can then redistribute Freecycle without the dependencies


#STATIC_LINK = TRUE

# Then set the paths:

STATIC_LIB_PATH=/usr/lib
STATIC_GLIB_PATH=/opt/gnome/lib  #if you use libinstpatch
STATIC_QT_PATH=$(QTDIR) # if you are linking qt statically

# You maybe don't want to link statically jack and/or qt ?
# If so, comment the following lines :

#STATIC_LINK_JACK = TRUE
#STATIC_LINK_QT = TRUE

# If you want to statically link qt, you have to specify the path to the sources
# in fact, you need only $$QT_SOURCE_PATH/network/qsocket.h and $$QT_SOURCE_PATH/network/qsocket.cpp
QT_SOURCE_PATH = /storage/dl/qt/qt-x11-free-3.3.5/qt/src/


################          END USER EDITABLE PART       ###############

JACKINCLUDES += $$join(INCLUDEPATH,"/jack/jack.h -o -e ",,/jack/jack.h)
ALSAINCLUDES += $$join(INCLUDEPATH,"/alsa/asoundlib.h -o -e  ",,/alsa/asoundlib.h)
LIBINSTPATCHINCLUDES += $$join(INCLUDEPATH,"/libinstpatch-1.0/libinstpatch/libinstpatch.h  -o -e ",,/libinstpatch-1.0/libinstpatch/libinstpatch.h)
AUBIOINCLUDES += $$join(INCLUDEPATH,"/aubio/aubio.h  -o -e ",,/aubio/aubio.h)
SOUNDTOUCHINCLUDES += $$join(INCLUDEPATH,"/soundtouch/SoundTouch.h  -o -e ",,/soundtouch/SoundTouch.h)
PORTMIDIINCLUDES += $$join(INCLUDEPATH,"/portmidi.h  -o -e ",,/portmidi.h)
PORTAUDIOINCLUDES += $$join(INCLUDEPATH,"/portaudio.h  -o -e ",,/portaudio.h)

contains(DEFINES, HAS_JACK){
    #message(Searching for Jack includes in: $$JACKINCLUDES)
    !system (test -e $$JACKINCLUDES){
        DEFINES -= HAS_JACK
        message("Jack includes not found!")
    }else{
        message("Jack includes found!")
    }
}

contains(DEFINES, HAS_PORTMIDI){
    #message(Searching for Portmidi includes in: $$PORTMIDIINCLUDES)
    !system (test -e $$PORTMIDIINCLUDES){
        DEFINES -= HAS_PORTMIDI
        message("Portmidi includes not found!")
    }else{
        message("Portmidi includes found!")
    }
}

contains(DEFINES, HAS_PORTAUDIO){
    #message(Searching for Portaudio includes in: $$PORTAUDIOINCLUDES)
    !system (test -e $$PORTAUDIOINCLUDES){
        DEFINES -= HAS_PORTAUDIO
        message("Portaudio includes not found!")
    }else{
        message("Portaudio includes found!")
    }
}

contains(DEFINES, HAS_ALSA){
    #message(Searching for ALSA includes in: $$ALSAINCLUDES)
    !system (test -e $$ALSAINCLUDES){
        message("ALSA includes not found!")
        DEFINES -= HAS_ALSA
        !macx:!win32{
            DEFINES-=HAS_PORTAUDIO
            message("Cannot build Portaudio without ALSA on this system!")
            DEFINES-=HAS_PORTMIDI
            message("Cannot build Portmidi without ALSA on this system!")
        }
        
    }else{
        message("ALSA includes found!")
    }
}

contains(DEFINES, HAS_LIBINSTPATCH){
    #message(Searching for LibInstPatch includes in: $$LIBINSTPATCHINCLUDES)
    !system (test -e $$LIBINSTPATCHINCLUDES){
        DEFINES -= HAS_LIBINSTPATCH
        message("libinstpatch includes not found!")
    }else{
        message("libinstpatch includes found!")
    }
}

contains(DEFINES, HAS_AUBIO){
    #message(Searching for Aubio includes in: $$AUBIOINCLUDES)
    !system (test -e $$AUBIOINCLUDES){
        DEFINES -= HAS_AUBIO
        message("aubio includes not found!")
    }else{
        message("aubio includes found!")
    }
}

contains(DEFINES, HAS_SOUNDTOUCH){
    #message(Searching for SoundTouch includes in: $$SOUNDTOUCHINCLUDES)
    !system (test -e $$SOUNDTOUCHINCLUDES){
        DEFINES -= HAS_SOUNDTOUCH
        message("SoundTouch includes not found!")
    }else{
        message("SoundTouch includes found!")
    }
}


!isEmpty( STATIC_LINK ) {
    message("Attempting the static link")
}


!isEmpty( STATIC_LINK ):!isEmpty(STATIC_LINK_QT) {
    exists ($$STATIC_QT_PATH/lib/libqt-mt.a){
        QMAKE_LIBS_QT =
        QMAKE_LIBS_QT_THREAD =
        LIBS += $$STATIC_QT_PATH/lib/libqt-mt.a
        LIBS += $$STATIC_QT_PATH/lib/libqassistantclient.a
        unix{
            LIBS += -lXinerama -lXcursor -lSM -lICE -lXrandr -lXft -lfreetype
            LIBS += -lpthread 
        }
        macx{
            LIBS += -lz -framework Carbon
        }
        HEADERS += $$QT_SOURCE_PATH/network/qsocket.h 
        SOURCES += $$QT_SOURCE_PATH/network/qsocket.cpp
        message("Qt will be linked statically")
    }else {
      message("Qt will be linked dynamically")
    }
}


contains(DEFINES, HAS_AUBIO){
    isEmpty( STATIC_LINK ) {
        LIBS+= -laubio
    } else {
        LIBS+= $$STATIC_LIB_PATH/libaubio.a
        message("Aubio will be linked statically")
    }
}


contains(DEFINES, HAS_PORTMIDI){
    isEmpty( STATIC_LINK ) {
        LIBS+=-lportmidi -lporttime
    } else {
        LIBS+=$$STATIC_LIB_PATH/libportmidi.a $$STATIC_LIB_PATH/libporttime.a
        message("Portmidi will be linked statically")
    }
    HEADERS += portmidimidiinput.h
    SOURCES += portmidimidiinput.cpp
           
}

contains(DEFINES, HAS_PORTAUDIO){
        isEmpty( STATIC_LINK ) {
            LIBS+=-lportaudio
            LIBS*=-lasound
        } else {
            LIBS+=$$STATIC_LIB_PATH/libportaudio.a
            exists($$STATIC_LIB_PATH/libasound.a){
                LIBS += $$STATIC_LIB_PATH/libasound.a
                LIBS+= -lresmgr
                message("Portaudio will be linked statically")
            }
        }
}

contains(DEFINES, HAS_ALSA){
        #isEmpty( STATIC_LINK ) {
            LIBS*=-lasound
        #} else {
        #    LIBS+=$$STATIC_LIB_PATH/libasound.a
        #    message("ALSA will be linked statically")
        #}
        HEADERS += alsaconfigdialog.h alsaseqmidiinput.h 

        SOURCES += alsaconfigdialog.cpp alsaseqmidiinput.cpp 
}

contains(DEFINES, HAS_JACK){
    isEmpty( STATIC_LINK ) {
        LIBS+= -ljack
    } else:!isEmpty(STATIC_LINK_JACK) {
        exists ($$STATIC_LIB_PATH/libjack.a){
            LIBS+=$$STATIC_LIB_PATH/libjack.a
            message("Jack will be linked statically")
        } else {
            LIBS+= -ljack
            message("Jack will be linked dynamically")
        }
    } else {
         LIBS+= -ljack
         message("Jack will be linked dynamically")
    }
}


contains(DEFINES, HAS_LIBINSTPATCH){
    isEmpty( STATIC_LINK ) {
       LIBS+= -lgobject-2.0 \
        -lgthread-2.0 \
        -lglib-2.0 \
        -linstpatch-1.0
    } else {
       LIBS+= $$STATIC_GLIB_PATH/libgobject-2.0.a \
        $$STATIC_GLIB_PATH/libgthread-2.0.a \
        $$STATIC_GLIB_PATH/libglib-2.0.a \
        $$STATIC_LIB_PATH/libinstpatch.a \
        $$STATIC_LIB_PATH/libFLAC.a \
        $$STATIC_LIB_PATH/libaudiofile.a
        message("libinstpatch will be linked statically")
    }
    

    HEADERS += sf2manager.h \
            gigamanager.h \
            dlsmanager.h
    
    SOURCES += sf2manager.cpp \
           gigamanager.cpp \
           dlsmanager.cpp

}

contains(DEFINES, HAS_SOUNDTOUCH){
    isEmpty( STATIC_LINK ) {
        LIBS+=-lSoundTouch
    } else {
        LIBS+=$$STATIC_LIB_PATH/libSoundTouch.a
        message("libSoundTouch will be linked statically")
    }
}

isEmpty( STATIC_LINK ) {
    LIBS += -lqassistantclient -lfftw3f -lfftw3 -lsndfile
} else {
    LIBS += $$STATIC_LIB_PATH/libfftw3f.a $$STATIC_LIB_PATH/libfftw3.a \
       $$STATIC_LIB_PATH/libsndfile.a
       message("libsndfile will be linked statically")
       message("FFTW3 will be linked statically")
       isEmpty(STATIC_LINK_QT) {
        LIBS += -lqassistantclient
       }
}

contains(DEFINES,HAS_PORTMIDI) DEFINES*=HAS_MIDI
contains(DEFINES,HAS_ALSA) DEFINES*=HAS_MIDI

contains(DEFINES, HAS_MIDI){
    message("Building Freecycle with midi support")
    HEADERS += midiinput.h \
	      midiinputevent.h \
              midiinputthread.h \
	      midiconfigdialog.h

    SOURCES += midiinput.cpp \
               midiinputevent.cpp \
	       midiinputthread.cpp \
	       midiconfigdialog.cpp
}
