#!/usr/bin/perl

use strict;
use warnings;
use autodie;
use File::Spec;


my $src_dir = shift(@ARGV);

sub _slurp
{
    my $filename = shift;

    open my $in, '<', $filename
        or die "Cannot open '$filename' for slurping - $!";

    local $/;
    my $contents = <$in>;

    close($in);

    return $contents;
}

sub fn
{
    return File::Spec->catfile($src_dir, shift());
}

my $text = _slurp(fn("rate_state.h"));

my $type_name = 'fc_solve_seq_cards_power_type_t';
my $array_name = 'fc_solve_seqs_over_cards_lookup';
my $power_name = 'FCS_BEFS_SEQS_OVER_RENEGADE_CARDS_EXPONENT';
my ($power) = $text =~ m/^#define \Q$power_name\E (\d+\.\d+)\s*$/ms;
my ($decl, $limit) = $text =~ m/^extern (const \Q$type_name\E \Q$array_name\E\[([^\]]+)\]);\s*$/ms;

if (!defined($power) or !defined($limit))
{
    die "Could not match power and/or limit";
}

my $top = eval($limit);

# my @data = (map { int( ($_ ** $power) * 128 * 1024 ) } (0 .. $top-1));
my @data = (map { $_ ** $power } (0 .. $top-1));

open my $out_fh, '>', fn("rate_state.c");
print {$out_fh} <<"EOF";
/*
 * This file is part of Freecell Solver and was generated by
 * gen_rate_state_c.pl .
 * Do not modify directly.
 */

#include "rate_state.h"

/*
 * This contains the exponents of the first few integers to the power
 * of $power_name .
 */
$decl =
{
@{[join(", ", @data)]}
};
EOF

close ($out_fh);
