// Copyright 2007 "Gilles Degottex"

// This file is part of "Music"

// "Music" is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// "Music" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "Filter.h"

// #include <iostream>
using namespace std;
#include <CppAddons/CAMath.h>
using namespace Math;
#include "Music.h"

// b = fir1(32,[0.00001 0.23]);
vector<double> Music::fir1_lowpass(int n, double cutoff)
{
	vector<double> b(n);

	int d = (n-1)/2;

	for(size_t i=0; i<b.size(); i++)
		b[i] = cutoff*sinc(cutoff*(i-d));

	return b;
}

vector<double> Music::fir1_highpass(int n, double cutoff)
{
	vector<double> b(n);

	int d = (n-1)/2;

	double s=0.0;
	for(size_t i=0; i<b.size(); i++)
	{
		b[i] = cutoff*sinc(cutoff*(i-d));
		s += b[i];
	}

	for(size_t i=0; i<b.size(); i++)
		b[i] = -b[i];
	b[d] = s+b[d];

	return b;
}

vector<double> Music::fir1_bandpass(int n, double low_cutoff, double high_cutoff)
{
	vector<double> b(n, 0.0);

	if(low_cutoff>high_cutoff)
		return b;

	vector<double> lowf = fir1_lowpass(n, low_cutoff);
	vector<double> highf = fir1_highpass(n, high_cutoff);

	return conv(lowf, highf);
}

Music::FIRRTFilter::FIRRTFilter(std::vector<double>& imp_res)
{
	assert(imp_res.size()>0);

	m_imp_res = imp_res;
// 			m_to_filter.reserve(imp_res.size());
}

double Music::FIRRTFilter::operator()(double v)
{
	double value = 0.0;

	m_to_filter.push_front(v);

	if(m_to_filter.size()>=m_imp_res.size())
	{
				// convolve
		for(size_t i=0; i<m_imp_res.size(); i++)
			value += m_imp_res[i]*m_to_filter[i];

// 		if(decim++%4==0)
// 			m_queue.push_front(value);

		// drop unused data
		m_to_filter.pop_back();
	}

	return value;
}

Music::RectangularHighPassRTFilter::RectangularHighPassRTFilter(int N)
{
	reset(N);
}
void Music::RectangularHighPassRTFilter::reset(int N)
{
	if(N<1)	N=1;

	m_N = N;
	m_sum = 0.0;
	m_summed_values.clear();
}
double Music::RectangularHighPassRTFilter::operator()(double v)
{
	m_summed_values.push_front(v);
	m_sum += v;
	while(int(m_summed_values.size())>m_N)
	{
		m_sum -= m_summed_values.back();

		m_summed_values.pop_back();
	}

	return m_summed_values[m_summed_values.size()/2] - m_sum/m_summed_values.size();
}

double Music::RectangularLowPassRTFilter::operator()(double v)
{
	return v;
}

double Music::RectangularBandPassRTFilter::operator()(double v)
{
	return v;
}

/*
LP and HP filter
Type : biquad, tweaked butterworthReferences : Posted by Patrice TarrabiaCode : www.musicdsp.org
r  = rez amount, from sqrt(2) to ~ 0.1
f  = cutoff frequency
(from ~0 Hz to SampleRate/2 - though many
synths seem to filter only  up to SampleRate/4)

The filter algo:
out(n) = a1 * in + a2 * in(n-1) + a3 * in(n-2) - b1*out(n-1) - b2*out(n-2)

Lowpass:
      c = 1.0 / tan(pi * f / sample_rate);

      a1 = 1.0 / ( 1.0 + r * c + c * c);
      a2 = 2* a1;
      a3 = a1;
      b1 = 2.0 * ( 1.0 - c*c) * a1;
      b2 = ( 1.0 - r * c + c * c) * a1;

Hipass:
      c = tan(pi * f / sample_rate);

      a1 = 1.0 / ( 1.0 + r * c + c * c);
      a2 = -2*a1;
      a3 = a1;
      b1 = 2.0 * ( c*c - 1.0) * a1;
      b2 = ( 1.0 - r * c + c * c) * a1;
*/
