/* This file has been automatically generated by builder part of the ferite distribution */
/* file: system_System.c */
/* namespace: System */

#include <ferite.h>       /* we need this without a doubt */
#include "system_header.h"  /* this is the module header */

FE_NS_FUNCTION( system_System_exec )
{
   char *cmd = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, cmd );

   { /* Main function body. */
 	  
	  execl("/bin/sh", "/bin/sh", "-c", cmd, NULL);
	  /*  If we run the following, we failed! */
	  perror("ferite System::exec().execl()");
	  exit(1);
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_gc )
{

   { /* Main function body. */
 
	  __ferite_check_gc();
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_getcwd )
{

   { /* Main function body. */
 
	  char buff[PATH_MAX];
	  FeriteVariable *var = fe_new_str( "System::getcwd", getcwd(buff, PATH_MAX) );
	  SET_FE_NS_STRING("System.cwd", buff);
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_signalpid )
{
   double pid;
   double signum;

   ferite_get_parameters( params, 2, &pid, &signum );

   { /* Main function body. */
 
	  int ret= kill( (pid_t)pid, (int)signum);
	  long l;
	  
	  l= ret==-1? errno : 0;
	  SET_FE_NS_LONG("err.errno",l);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_statusStopped )
{

   { /* Main function body. */
 
	  int status;
	  long ret;
	  FeriteNamespaceBucket *nsb = __ferite_find_namespace( script,script->mainns, "System.status", 0 ); 
	  FeriteVariable *var = nsb->data;
	  status = VAI(var);
	  ret=(WIFSTOPPED(status) ? WSTOPSIG(status) : -1L);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_statusSignaled )
{

   { /* Main function body. */
 
	  int status;
	  long ret;
	  FeriteNamespaceBucket *nsb = __ferite_find_namespace( script,script->mainns, "System.status", 0 ); 
	  FeriteVariable *var = nsb->data;
	  status = VAI(var);
	  ret=(WIFSIGNALED(status) ? WTERMSIG(status) : -1L);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_statusExited )
{

   { /* Main function body. */
 
	  int status;
	  long ret;
	  FeriteNamespaceBucket *nsb =  __ferite_find_namespace( script,script->mainns, "System.status", 0 ); 
	  FeriteVariable *var = nsb->data;
	  status = VAI(var);
	  ret = (WIFEXITED(status) ? WEXITSTATUS(status) : -1L);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_waitpid )
{
   double pid;
   double NOBLOCK;
   double STOPPED;

   ferite_get_parameters( params, 3, &pid, &NOBLOCK, &STOPPED );

   { /* Main function body. */
 
	  pid_t ret;
	  int status, options;
	  long l;
	  
	  options= (NOBLOCK ? WNOHANG : 0);
	  options|=(STOPPED ? WUNTRACED : 0 );
	  ret=waitpid( (pid_t)pid, &status, options);
	  l= ret==-1? errno : 0;
	  SET_FE_NS_LONG("err.errno",l);
	  SET_FE_NS_LONG("System.status",(long)status);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_scriptName )
{

   { /* Main function body. */
 
	  FeriteVariable *var = fe_new_str( "System::scriptName", script->filename);
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_warning )
{
   char *message = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, message );

   { /* Main function body. */
 
	  ferite_warning( script, "%s", message );
	  ffree( message );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_fork )
{

   { /* Main function body. */
 
	  pid_t pid;
	  long l;

	  pid=fork();
	  l= pid==-1? errno : 0;
	  SET_FE_NS_LONG("err.errno",l);
	  FE_RETURN_LONG( (long)pid );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_system )
{
   char *cmd = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, cmd );

   { /* Main function body. */
 	
	  pid_t pid;
	  long l;
	  
	  pid = fork();
	  l= pid==-1? errno : 0;
	  SET_FE_NS_LONG("err.errno",l);
	  if(!pid)
	  { /*  childe... */
		 execl("/bin/sh", "/bin/sh", "-c", cmd, NULL);
		 /*  If we run the following, we failed! */
		 perror("ferite System::system().execl()");
		 exit(127);
	  }
	  /*  parent or error.. */
	  ffree( cmd );
	  FE_RETURN_LONG( pid );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_usleep )
{
   double usecs;

   ferite_get_parameters( params, 1, &usecs );

   { /* Main function body. */
 
	  usleep( (unsigned long)usecs );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_chdir )
{
   char *newdir = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, newdir );

   { /* Main function body. */
 
	  int ret;
	  long l;
	  ret=chdir(newdir);
	  if(!ret)
	  { 
		 char buffer[PATH_MAX];
		 getcwd(buffer, PATH_MAX);
		 SET_FE_NS_STRING("System.cwd", buffer)
	  }
	  l = ret==-1? errno : 0;
	  SET_FE_NS_LONG("err.errno", (long)ret);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_strerror )
{
   double what;

   ferite_get_parameters( params, 1, &what );

   { /* Main function body. */
 
	  char buf[1024];
	  FeriteVariable *var;
	  int N= (int)what;
	  
	  switch( N )
	  {
	   case -1:	sprintf(buf,"%d: Generic Error", N); break;
	   case  0:	sprintf(buf,"%d: Success", N); break;
	   default:	sprintf(buf,"%d: %s", N, strerror(N) );
		 break;
		 
	  }
	  var = fe_new_str( "System::strerror", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_error )
{
   char *message = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, message );

   { /* Main function body. */
 
	  ferite_error( script, "%s", message );
	  ffree( message );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_wait )
{

   { /* Main function body. */
 
	  pid_t ret;
	  int status;
	  long l;
	  
	  ret=wait(&status);
	  l= ret==-1? errno : 0;
	  SET_FE_NS_LONG("err.errno",l);
	  SET_FE_NS_LONG("System.status",(long)status);
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_System_exit )
{

   { /* Main function body. */
 
	  __ferite_stop_execution( script );
   
   }
   FE_RETURN_VOID;
}

