/* This file has been automatically generated by builder part of the ferite distribution */
/* file: string_String.c */
/* namespace: String */

#include <ferite.h>       /* we need this without a doubt */
#include "string_header.h"  /* this is the module header */

FE_NS_FUNCTION( string_String_isAlpha )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch = isalpha(ch%256) != 0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isSpace )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= isspace(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_nCompareNoCase )
{
   char *a = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *b = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );
   double max;

   ferite_get_parameters( params, 3, a, b, &max );

   { /* Main function body. */
 
	  int result;
	  
	  result= strncasecmp(a, b, (size_t)max);
	  ffree( a );
	  ffree( b );
      FE_RETURN_LONG( (long)result );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_nCompareCase )
{
   char *a = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *b = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );
   double max;

   ferite_get_parameters( params, 3, a, b, &max );

   { /* Main function body. */
 
	  int result;
	  
	  result= strncmp(a, b, (size_t)max);
	  ffree( a );
	  ffree( b );
	  FE_RETURN_LONG( (long)result );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_compareNoCase )
{
   char *a = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *b = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );

   ferite_get_parameters( params, 2, a, b );

   { /* Main function body. */
 
	  int result;
	  
	  result= strcasecmp(a, b);
	  ffree( a );
	  ffree( b );
	  FE_RETURN_LONG( (long)result );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_compareCase )
{
   char *a = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *b = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );

   ferite_get_parameters( params, 2, a, b );

   { /* Main function body. */
 
	  int result;
	  
	  result= strcmp(a, b);
	  ffree( a );
	  ffree( b );
	  FE_RETURN_LONG( (long)result );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_toDouble )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
	  double value;
	  value = atof( str );
	  ffree( str );
	  FE_RETURN_DOUBLE( value );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_toLong )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
	  long value;
	  value = atol( str );
	  ffree( str );
	  FE_RETURN_LONG( value );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isGraph )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= isgraph(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_length )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
	  size_t	length;
	  
	  length = strlen( str );
	  ffree( str );
	  FE_RETURN_DOUBLE( (double)length );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isCntrl )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
   
	  int ch=(int)cc;
	  ch= iscntrl(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_postTrim )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *delims = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );

   ferite_get_parameters( params, 2, str, delims );

   { /* Main function body. */
 
	  char *buf = FE_CLEAN_STRING(strlen(str)+1), *s, *e;
	  FeriteVariable *var;
	  
	  if( !(*delims) )
	  {
		 var = fe_new_str( "FAIL string::postTrim - delims", buf );
		 ffree( str );
		 ffree( delims );
		 ffree( buf );
		 FE_RETURN_VAR( var );
	  }
	  
	  s=str;
	  e=s+strlen(s)-1;
	  if(e-s>1)
	  {
		 while( *s && strchr(delims, *(e-1)) ) e--;
		 *e=0;
	  }
	  else if( strchr(delims, *e) )
	    *e=0;
	  if(*s)
	    strcpy(buf, s);
	  
	  var = fe_new_str( "string::postTrim", buf );
	  ffree( buf );
	  ffree( str );
	  ffree( delims );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_preTrim )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *delims = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );

   ferite_get_parameters( params, 2, str, delims );

   { /* Main function body. */
 
	  char *buf = FE_CLEAN_STRING(strlen(str)+1), *s, *e;
	  FeriteVariable *var;
	  
	  if( !(*delims) )
	  {
		 var = fe_new_str( "FAIL string::preTrim - delims", buf );
		 ffree( str );
		 ffree( delims );
		 ffree( buf );
		 FE_RETURN_VAR( var );
	  }
	  
	  s=str;
	  e=s+strlen(s)-1;
	  while( *s && strchr(delims, *s) ) s++;
	  
	  if(*s)
	    strcpy(buf, s);
	  
	  var = fe_new_str( "string::preTrim", buf );
	  ffree( buf );
	  ffree( str );
	  ffree( delims );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_copySection )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   double start;
   double end;

   ferite_get_parameters( params, 3, str, &start, &end );

   { /* Main function body. */
 
	  int length = strlen( str );
	  unsigned i,s=(unsigned)start, e=(unsigned)end;
	  char *returnStr = NULL;
	  FeriteVariable *returnValue = NULL;
	  
	  if( s>=e || e>=length )
	  { /*pfv:
		 *	We must return the same damnthing - even when INVALID!
		 *	We really require a 'BadThing' type that's universal.
		 */
		 ffree( str );
		 ferite_error( script, "FAIL string::sub - start/end" );
		 FE_RETURN_VOID;
	  }
	  else
	  {
		 returnStr= FE_CLEAN_STRING(length+1);
		 for(i=s; i<e; i++)
		   returnStr[i-s]=str[i];
		 returnStr[i-s]=0;
		 
		 // Generate the typical return..
		 returnValue = fe_new_str( "string::copySection", returnStr );
		 ffree( str );
		 ffree( returnStr );
		 FE_RETURN_VAR( returnValue );
	  }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isUpper )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= isupper(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isLower )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= islower(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_toUpper )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
	  char *buf = FE_CLEAN_STRING(strlen(str)+1);
	  register char *s=buf;
	  FeriteVariable *result;
	  
	  strcpy(buf,str);
	  while(*s) *s= (char)toupper(*s), s++;
	  result = fe_new_str( "string::toUpper", buf );
	  ffree( buf );
	  ffree( str );
	  FE_RETURN_VAR( result );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_toLower )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   double upper;

   ferite_get_parameters( params, 2, str, &upper );

   { /* Main function body. */
 
	  char *buf = FE_CLEAN_STRING(strlen(str)+1);
	  register char *s=buf;
	  FeriteVariable *result;
	  
	  strcpy(buf,str);
	  while(*s) *s= (char)tolower(*s), s++;
	  result = fe_new_str( "string::toLower", buf );
	  ffree( buf );
	  ffree( str );
	  FE_RETURN_VAR( result );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isXdigit )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= isxdigit(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isPunct )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
  
	  int ch=(int)cc;
	  ch= ispunct(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isPrint )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= isprint(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_isDigit )
{
   double cc;

   ferite_get_parameters( params, 1, &cc );

   { /* Main function body. */
 
	  int ch=(int)cc;
	  ch= isdigit(ch%256)!=0;
	  FE_RETURN_LONG( (long)ch );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( string_String_toArray )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *delims = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );

   ferite_get_parameters( params, 2, str, delims );

   { /* Main function body. */
 
	  char *name= NULL, *tmp= NULL;
	  FeriteVariable *var, *array;
	  int	length= strlen( str ), lsub, i;
	  char	*left, *right;
	  
	  name=	FE_CLEAN_STRING(length+1);
	  tmp=	FE_CLEAN_STRING(length+1);
	  array = __ferite_create_uarray_variable( "string::split", 100 );
	  
	  left=str;
	  i=0;
	  if( *delims ) while(left && *left)
	  {
		 // skip *ALL* leading delim
		 while(*left && strchr(delims, *left)) left++;
		 
		 if(*left)
		 {
			// skip all *VALID* characters..
			right=left;
			while(*right && !strchr(delims, *(right++)));
			
			// Everything left..right (inclusive) are substring
			lsub=right-left;
			sprintf(tmp, "%.*s", lsub, left);
			
			// add the bitch NOW!
			sprintf( name,"hash-%d",i );
			var = fe_new_str( name, tmp );
			__ferite_uarray_add( script, VAUA(array), var, NULL, i++ );
			
		 }
		 
		 // step past previous substring to whatever remains..
		 left=right;
		 
	  }
	  ffree( str );
	  ffree( delims );
	  ffree( name );
	  ffree( tmp );
	  FE_RETURN_VAR( array );
   
   }
   FE_RETURN_VOID;
}

