/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_VARIABLES_H__
#define __FERITE_VARIABLES_H__

#define MAX_FERITE_VARS   50

#define F_VAR_VOID        0

#define F_VAR_LONG        1
#define F_VAR_STR         2
#define F_VAR_DOUBLE      3
#define F_VAR_OBJ         5
#define F_VAR_NS          7  /* hidden internal to make things work */
#define F_VAR_CLASS       8  /* blart, and again :) */
#define F_VAR_UARRAY	  9
#define F_VAR_NUM         F_VAR_LONG

#define F_VAR_ARRAY_LINEAR 8
#define F_VAR_ARRAY_ASSOC  9
#define F_VAR_ARRAY_UNIFIED 10


#define VAI( var )  var->data.lval
#define VAF( var )  var->data.dval
#define VAS( var )  var->data.sval
#define vVAP( var )  var->data.pval
#define VAO( var )  var->data.oval
#define VAUA( var ) var->data.aval

#define PTR2VAR( var ) ((FeriteVariable *)var)
#define PARGX( var )   ((FeriteRegex *)(var))

#define DUPLICATE_LONG_VARIABLE( a, b )  \
     b = __ferite_duplicate_variable( script, a );

#define DUPLICATE_DOUBLE_VARIABLE( a, b ) \
     b = __ferite_duplicate_variable( script, a );

#define DUPLICATE_STR_VARIABLE( a, b )  \
     b = __ferite_duplicate_variable( script, a );

#define MARK_VARIABLE_AS_DISPOSABLE( var ) if( var ) var->flags.disposable = 1;
#define MARK_VARIABLE_AS_COMPILED( var ) if( var ) var->flags.compiled = 1;
#define MARK_VARIABLE_AS_CONSTANT( var ) if( var ) var->flags.constant = 1;

int                 __ferite_variable_hash_loc( char *name, int size );
FeriteVariable     *__ferite_variable_alloc(void);
void                __ferite_variable_destroy( FeriteScript *script, FeriteVariable *var );
FeriteVariableHash *__ferite_variable_hash_alloc( FeriteScript *script, int size );
FeriteVariableHash *__ferite_duplicate_variable_hash( FeriteScript *script, FeriteVariableHash *hash );
void                __ferite_delete_variable_hash( FeriteScript *script, FeriteVariableHash *hash );
void                __ferite_add_variable_to_hash( FeriteScript *script, FeriteVariableHash *hash, FeriteVariable *var );
FeriteVariable     *__ferite_get_variable_from_hash( FeriteScript *script, FeriteVariableHash *hash, char *name );

FeriteVariable     *__ferite_create_string_variable( char *name, char *data );
FeriteVariable     *__ferite_create_number_long_variable( char *name, long data );
FeriteVariable     *__ferite_create_number_double_variable( char *name, double data );
FeriteVariable     *__ferite_create_object_variable( char *name );
FeriteVariable     *__ferite_create_uarray_variable( char *name, int size );
FeriteVariable     *__ferite_duplicate_variable( FeriteScript *script, FeriteVariable * var );
FeriteVariable     *__ferite_create_void_variable( char *name );
void                __ferite_variables_dump( FeriteVariableHash *hash );
char               *__ferite_variable_id_to_str( FeriteScript *script, int variable );
int                 __ferite_variable_is_false( FeriteScript *script, FeriteVariable *var );

#endif /* __FERITE_VARIABLES_H__ */

