/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)

MEMORY
{
	ram (RW)	: org = 0x80000000, len = 8k
	flash (RX)	: org = 0xfffd0000, len = 64k
}

_estack = ORIGIN(ram) + LENGTH(ram);

SECTIONS
{
	.text : {
		. = ALIGN(4);
		_stext = .;
		*(.reset)
		*(.text*)
		*(.rodata)
		. = ALIGN(4);
		_etext = .;
	} > flash

	.data : AT (_etext) {
		. = ALIGN(4);
		*(.data)
		. = ALIGN(4);
		_edata = .;
	} > ram

	.bss (NOLOAD) : {
		. = ALIGN(4);
		*(.bss)
		. = ALIGN(4);
		_ebss = .;
	}

	/DISCARD/ : {
		*(*)
	}

	end = .;
}
