/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue.h"

#include "conv_gen.h"
#include "conv_zero.h"

#include "media_gen_floppy.h"

#define COMP_(x) media_gen_floppy_ ## x

struct cpssp {
	/* Config */
	char name[1024];
	const char *image;
	unsigned int size;

	void *media;
};

static void
COMP_(connect)(void *_cpssp, const char *port, void *sig)
{
	fixme();
}

static void
COMP_(disconnect)(void *_cpssp, const char *port)
{
	fixme();
}

static int
COMP_(wp)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */
	return cpssp->image != NULL;
}

static int
COMP_(read)(
	void *_cpssp,
	unsigned int blk,
	uint8_t *data,
	uint8_t *trackp,
	uint8_t *sectorp
)
{
	struct cpssp *cpssp = _cpssp;

	/*
	 * Check for unreadable sectors.
	 */
	/* FIXME */

	if (cpssp->size <= blk) {
		return 0;
	}

	storage_read(cpssp->media, data, 512,
			(unsigned long long) blk * 512);
	*trackp = blk / (2 * 18);
	*sectorp = blk % 18 + 1;
	return 1;
}

static int
COMP_(write)(
	void *_cpssp,
	unsigned int blk,
	const uint8_t *data,
	uint8_t track,
	uint8_t sector
)
{
	struct cpssp *cpssp = _cpssp;

	if (cpssp->size <= blk) {
		return 0;
	}

	storage_write(cpssp->media, data, 512,
			(unsigned long long) blk * 512);
	return 1;
}

void *
COMP_(create)(
	const char *name,
	const char *size,
	const char *image,
	struct sig_manage *manage,
	struct sig_floppy *port_connect
)
{
	static const struct sig_manage_funcs manage_funcs = {
		.connect = COMP_(connect),
		.disconnect = COMP_(disconnect),
	};
	static const struct sig_floppy_funcs connect_funcs = {
		.wp = COMP_(wp),
		.read = COMP_(read),
		.write = COMP_(write),
	};
	struct cpssp *cpssp;
	char path[1024];

	if (! size) size = "2880"; /* 2*80*18 */

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);

	/* name */
	strcpy(cpssp->name, system_path());

	/* size */
	cpssp->size = atoi(size);
	assert(cpssp->size == 2880); /* FIXME */

	/* contents */
	cpssp->image = image;

	assert(strlen(system_path()) + strlen(".media") < sizeof(path));
	sprintf(path, "%s.media", system_path());
	cpssp->media = storage_create(path,
			(uint64_t) cpssp->size * 512,
			image, conv_gen_open, conv_gen_close, conv_gen_read);
	assert(cpssp->media);

	/* Write magic? FIXME */

	/* Call */
	sig_manage_connect(manage, cpssp, &manage_funcs);
	sig_floppy_connect(port_connect, cpssp, &connect_funcs);

	/* Out */
	/* In */

	system_name_pop();

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int ret;

	ret = storage_destroy(cpssp->media);
	assert(0 <= ret);

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	void *savemedia = cpssp->media;
	const char *saveimage = cpssp->image;

	generic_resume(cpssp, sizeof(*cpssp), fComp);

	cpssp->media = savemedia;
	cpssp->image = saveimage;
}
