/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	int current_trigger_val;
	int channel_number;
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(event_triggered)(void *_cpssp, unsigned int val);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp, int channel_number);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(event_triggered)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp;
	cpssp = _cpssp;
	int mV;

	mV = SIG_mV(val);
	if (mV >= 2500 &&
		cpssp->NAME.current_trigger_val < 2500) {
		/* positive edge */
		register_event(cpssp, cpssp->NAME.channel_number, true);
	} else if(mV <= 2500
		&& cpssp->NAME.current_trigger_val > 2500) {
		/* negative edge */
		register_event(cpssp, cpssp->NAME.channel_number, false);
	}
	cpssp->NAME.current_trigger_val = mV;
}

static void
NAME_(create)(struct cpssp *cpssp, int channel_number)
{
	cpssp->NAME.channel_number = channel_number;
}

#endif /* BEHAVIOUR */
