/* $Id: libbuild.h,v 1.6 2009-01-28 13:57:50 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIBBUILD_H_INCLUDED
#define __LIBBUILD_H_INCLUDED

#include "config.h"

#define __stringify_1(x)	#x
#define __stringify(x)		__stringify_1(x)

#ifdef SYMBOL_USCORE
#define _C_LABEL(x)     _ ## x
#else
#define _C_LABEL(x)     x
#endif

/* force parameters to stack */
#if __GNUC__ >= 3
#define asmlinkage __attribute__((regparm(0)))
#else
#define asmlinkage
#endif

/* tell the compiler that the function is really used */
#if (__GNUC__ >= 3) && (__GNUC_MINOR__ >= 3)
#define __used __attribute__((__used__))
#else
#define __used __attribute__((__unused__))
#endif

#endif /* __LIBBUILD_H_INCLUDED */
