<?php

/*
   RemoteProcedureCalls for ewiki
   
   - allows for XmlRpcToWiki (v2)
   - provides OpenSearch API (v0)
   - can be used for ?binary=
   - currently disabled for _PROTECTED_MODE
*/



#-- load libs and server interface code
include("config.php");
error_reporting(0x00000000);

#-- interfaces and protocols
include("plugins/lib/wikiapi.php");
if (!function_exists("ewiki_opensearch_api")) include("plugins/lib/opensearch.php");
if (!function_exists("xmlrpc")) include("plugins/lib/xmlrpc.php");
#if (!function_exists("atom_server")) include("plugins/lib/atom-server.php");

#-- fail for:
if (EWIKI_PROTECTED_MODE) {
   die("The API is disabled, because it doesn't yet respect the _PROTECTED_MODE restrictions.");
}


#-- prepare API methods
$xmlrpc_methods = &$wikiapi;


#-- what kind of request
$rt = trim(strtok($_SERVER["HTTP_CONTENT_TYPE"].$_SERVER["CONTENT_TYPE"], ",;"));
switch ($rt) {

   #-- WikiApi
   case XMLRPC_MIME_OLD:
   case XMLRPC_MIME_NEW:
      xmlrpc_server();

   #-- Atom
   case "application/xml":
      // atom_server();

   #-- WikiSync
   case "application/vnd.php.serialized":
      include("tools/t_sync.php");
      
   #-- WebDAV
      //... (far away from that)
         
   default:
      header("Status: 401 Method Not Implemented");
      die("This is a backend interface for XML-RPC, PHP-RPC and Atom requests.\nGo away already!\n");
}

#-- other detection mechanism?
//...


?>