#!/usr/bin/env entity

<object>

  <window ondelete = "entity:quit" title = "Graph Test" 
   width = "500" height = "400">

    <object expand = "true" fill = "true" dragable="true">
      <menu name="test">
	<menuitem label="append?" onselect="print_selection"/>
      </menu>
      
      <graph name="mygraph" expand="true" fill="true" onselect="selection" 
	onbuttonpress="do_button_press">
        <graph-point name="foo1" x="1" y="30" size="10" type = "point" 
		color="#123445"/>
	<graph-point x="2" y="20" size="10" type = "point" color="#123445"/>
	<graph-point x="3" y="10.4" size="10" type = "point" color="#123445"/>
	<graph-point name="foo2" x="5" y="20" size="10" 
				type = "bar" color="#342050"/>
	<graph-point name="foo3" x="6" y="30" size="15" 
				type = "bar" color="#543090"/>
	<graph-point name="foo4" x="7" y="40" size="20" 
				type = "bar" color="#549090"/>
      </graph>
      <perl>
        <![CDATA[
	
	$value = 2.0;
	$color = 1;
	$num = .001;
	
	sub selection
	  {
	    my ($node, $x, $y, $x1, $x2) = @_;
            my $child;
	    
	    #print ("node is $node\n");
            my @children = $node->children_attrib ("selected", "true");
            foreach $child (@children)
              {
	         print "children_attrib selected $child\n";
              }
            my @children = $node->children_attrib_rx ("selected", "[tT].*");
            foreach $child (@children)
              {
	         print "children_attrib_rx selected $child\n";
              }
	    print ("selection - $x,$y to $x1,$x2\n");
	  }
	  
	sub set_graph
	  {

	    $value += 1.1;
	    
	    $color += 2;
	    if ($color > 99) {
	      $color = 0;
	    }
	    
	    $color_str = sprintf ("#2030%02d", $color);
	    
	    enode("graph-point.foo1")->attrib("y" => $value);
	    enode("graph-point.foo2")->attrib("y" => $value + 3);
	    enode("graph-point.foo3")->attrib("y" => $value + 5);
	    enode("graph-point.foo4")->attrib("y" => $value + 7);
	    
	    enode("graph-point.foo4")->attrib("color" => $color_str);

	    if ($value > 30) {
	      enode("timer.t")->attrib("interval" => "-1");
	    }
	  }
        sub do_button_press
          {
            my ($node, $bnum) = @_;
            
            print "bnum = $bnum\n";
            if (3 == $bnum)
              {
                my $menu = enode ("menu.test");
                $menu->attrib("popup" => "true") if $menu;
              }
           }
         sub print_selection
           {
             my $node = enode ("graph.mygraph");
             my @children = $node->children();
             my $child;
             foreach $child (@children)
               {
                if ($child->attrib_is_true ("selected") )
                  {
                    print "SELECTED $child\n\n";
                  }                             
              }
           }

        ]]>
      </perl>
      <timer name="t" interval = "100" action = "set_graph"/>
    </object>
  </window>
</object>
