/*
 * Utility routines for JIG-generated files
 * Copyright (c) 2000 Cylant Technology, LLC
 *
 * Author: Brian Bassett <bbassett@bbassett.net>
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 */

/*
 * $Source: /home/cvs/entity/libentitynjs/njs/jig.h,v $
 * $Id: jig.h,v 1.3 2000/07/25 05:26:06 imain Exp $
 */

#ifndef JIG_H
#define JIG_H

#include <njs/internal.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * js_return Return Macros
 */

#define js_return_any(retval)		\
  do {					\
    JS_COPY (js_retval, retval);	\
    goto js_done;			\
  } while (0)

#define js_return_null			\
  do {					\
    js_retval->type = JS_NULL;		\
    goto js_done;			\
  } while (0)

#define js_return_undef			\
  do {					\
    js_retval->type = JS_UNDEFINED;	\
    goto js_done;			\
  } while (0)

#define js_return_boolean(retval)	\
  do {					\
    js_retval->type = JS_BOOLEAN;	\
    js_retval->u.vboolean = retval;	\
    goto js_done;			\
  } while (0)

#define js_return_float(retval) 	\
  do {					\
    js_retval->type = JS_FLOAT;		\
    js_retval->u.vfloat = retval;	\
    goto js_done;			\
  } while (0)

#define js_return_int(retval)		\
  do {					\
    js_retval->type = JS_INTEGER;	\
    js_retval->u.vinteger = retval;	\
    goto js_done;			\
  } while (0)

#define js_return_nan			\
  do {					\
    js_retval->type = JS_NAN;		\
    goto js_done;			\
  } while (0)

#define js_return_jsstring(retval)					\
  do {									\
    js_retval->type = JS_STRING;					\
    js_retval->u.vstring = retval;					\
    goto js_done;							\
  } while (0)
#define js_return_cstring(retval)					\
  do {									\
    js_vm_make_string (js_vm, js_retval, retval, strlen(retval));	\
    goto js_done;							\
  } while (0)
#define js_return_cstring_static(retval)				\
  do {									\
    js_vm_make_static_string (js_vm, js_retval, retval, strlen(retval));\
    goto js_done;							\
  } while (0)

#define js_return_object(retval)	\
  do {					\
    js_retval->type = JS_OBJECT;	\
    js_retval->u.vobject = retval;	\
    goto js_done;			\
  } while (0)

#define js_return_array(retval)		\
  do {					\
    js_retval->type = JS_ARRAY;		\
    js_retval->u.varray = retval;	\
    goto js_done;			\
  } while (0)

/*
 * jig error messgaes
 */
#define JIG_ERROR(errmsg)						\
  do {									\
    js_vm_set_err (js_vm, "%s(): " errmsg, js_vm_symname(js_method));	\
    js_vm_error (js_vm);						\
  } while (0)

#define JIG_UNDEFINED \
  return JS_PROPERTY_UNKNOWN

#ifdef __cplusplus
}
#endif

#endif /* not JIG_H */
