/* BTP
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


#ifndef _BTP_DEBUG_H
#define _BTP_DEBUG_H

extern unsigned int btp_debug_flags;

/*

  dec	dec	hex
  00	1	0001	General
  01	2	0002	Functions
  02 	4	0004	Read packet (b_conn_io)
  03	8	0008	Write packet (b_conn_io)

  04	16	0010	Error (b_conn_io)
  05	32	0020	Ping (btp_proto)
  06	64	0040	Connection fail (btp_proto)
  07    128	0080	Tree relations (btp_proto)

  08	256	0100	Print tree periodically (btp-emcast only)
  09	512	0200	Connection handlers (b_conn_handler)
  10	1024	0400	Switching (btp_proto)
  11	2048	0800	Connection/disconnection (b_conn_connect)

  12	4096	1000	Shortcuts
  13	8192	2000	Node info (RDP)
  14   16384	4000	Sequence numbers
  15		8000	Multicast info and data

  20		Do aggressive switching (btp_proto)

  [Note this is different than the Jungle Monkey debug code.]

*/

#ifdef __GNUC__
#include <stdio.h>
#define BTPP(TYPE, FMT, ARGS...)  do { if (btp_debug_flags & (1 << TYPE)) fprintf(stderr, "BTP: " FMT, ## ARGS); } while(0)
#else
#define BTPP(TYPE, FMT, ARGS...) /* BTPP */
#endif

#endif /* _BTP_DEBUG_H */
