/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


#ifndef _B_PEER_H
#define _B_PEER_H

#include <glib.h>
#include <gnet/gnet.h>
#include <stdio.h>
/* No other dependencies */


typedef struct _BPeer BPeer;

typedef void (*BPeerUpdateFunc)(BPeer* bpeer, gpointer user_data);
/* Called when number of connections changes */

struct _BPeer
{
  GServer* server;	/* Server			*/

  gchar* hostname;	/* Peer hostname 		*/
  gint port;		/* Peer port (from server) 	*/

  GHashTable* handlers;	/* Peer handlers (name->handler)*/
  GSList*  conns;	/* Pending connections 		*/
};


typedef struct _BPeerHandler BPeerHandler;

struct _BConn;
typedef gboolean (*BPeerHandlerFunc)(struct _BConn* conn, gpointer user_data);
/* Returns FALSE if ok, TRUE if error */



#define  B_RECEIVE_HELLO_TIME	20000


BPeer*   b_peer_new (const gchar* hostname, const GInetAddr* iface, 
		     gboolean force_port);
void	 b_peer_delete (BPeer* peer);
void	 b_peer_print (FILE* file, BPeer* peer);

void	 b_peer_add_handler (BPeer* peer, const gchar* name, 
			     BPeerHandlerFunc func, gpointer user_data);
void	 b_peer_remove_handler (BPeer* peer, const gchar* name);
gboolean b_peer_has_handler (BPeer* peer, const gchar* name);
GSList*  b_peer_get_handler_data (BPeer* peer);

#endif /* _B_PEER_H */
