/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.emboss.jemboss.JembossJarUtil;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Favorites;
import org.emboss.jemboss.gui.KeywordSearch;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.SplashThread;
import org.emboss.jemboss.gui.SwingWorker;
import org.emboss.jemboss.gui.form.BuildJembossForm;
import org.emboss.jemboss.gui.form.MultiLineToolTipUI;
import org.emboss.jemboss.gui.startup.Database;
import org.emboss.jemboss.gui.startup.ProgList;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.GetACD;
import org.emboss.jemboss.soap.GetWossname;
import org.emboss.jemboss.soap.ServerSetup;
import org.emboss.jemboss.soap.ShowDB;

public class BuildProgramMenu {
    private static String[] db = new String[]{"", ""};
    private static Vector matrices = new Vector();
    private static Vector codons = new Vector();
    private Hashtable acdStore = new Hashtable();
    private AuthPopup splashing;
    private SplashThread splashThread;
    private static String[] envp;
    private int currentApp = -1;
    private Favorites favorites;

    public BuildProgramMenu(final JPanel menuPane, final JPanel formPane, JPanel pform, final JScrollPane scrollProgForm, final JembossParams mysettings, final boolean withSoap, final SetUpMenuBar mainMenu, final JFrame f) {
        String fs = new String(System.getProperty("file.separator"));
        final String cwd = new String(System.getProperty("user.dir") + fs);
        final Cursor cbusy = new Cursor(3);
        final Cursor cdone = new Cursor(0);
        if (withSoap) {
            this.splashing = new AuthPopup(mysettings, 400);
            if (mysettings.getUseAuth()) {
                this.splashing.setBottomPanel();
            }
            this.splashing.setSize(380, 200);
            this.splashing.pack();
            this.splashing.setVisible(true);
            this.splashThread = new SplashThread(this.splashing, 396);
            this.splashThread.start();
        } else {
            String[] env = null;
            env = JembossParams.isCygwin() ? new String[4] : new String[3];
            String ps = new String(System.getProperty("path.separator"));
            String embossBin = mysettings.getEmbossBin();
            String embossPath = mysettings.getEmbossPath();
            embossPath = new String("PATH" + ps + embossPath + ps + embossBin + ps);
            env[0] = "PATH=" + embossPath;
            env[1] = "PLPLOT_LIB=" + mysettings.getPlplot();
            env[2] = "HOME=" + System.getProperty("user.home") + fs;
            if (JembossParams.isCygwin()) {
                env[3] = "EMBOSSCYGROOT=" + JembossParams.getCygwinRoot();
            }
            envp = mysettings.getEmbossEnvironmentArray(env);
        }
        SwingWorker groupworker = new SwingWorker(){
            String woss = "";
            ProgList progs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                block5: {
                    this.putJembossLogo();
                    f.validate();
                    try {
                        if (withSoap) {
                            this.constructWithSoap();
                            break block5;
                        }
                        this.constructWithoutSoap();
                    }
                    catch (Exception exception) {}
                }
                return this.woss;
            }

            private void constructWithSoap() {
                mainMenu.setEnableFileManagers(false);
                mainMenu.setEnableShowResults(false);
                if (mysettings.getPublicSoapURL().startsWith("https") && !mysettings.getUseHTTPSProxy()) {
                    System.setProperty("https.proxyHost", "");
                    System.setProperty("http.proxyHost", "");
                    System.setProperty("proxyHost", "");
                    String[] settings = new String[]{new String("proxy.override=true")};
                    mysettings.updateJembossPropStrings(settings);
                }
                SwingWorker databaseworker = new SwingWorker(){

                    public Object construct() {
                        ShowDB showdb = null;
                        try {
                            showdb = new ShowDB(mysettings);
                        }
                        catch (Exception ex) {
                            BuildProgramMenu.this.splashing.doneSomething("Cannot connect!");
                            ServerSetup ss = new ServerSetup(mysettings);
                            int sso = JOptionPane.showConfirmDialog(f, ss, "Check Settings", 2, 0, null);
                            if (sso == 0) {
                                ss.setNewSettings();
                            } else {
                                System.exit(0);
                            }
                            try {
                                showdb = new ShowDB(mysettings);
                            }
                            catch (Exception exp) {
                                exp.printStackTrace();
                            }
                        }
                        String showdbOut = showdb.getDBText();
                        Database d = new Database(showdbOut);
                        BuildProgramMenu.access$402(d.getDB());
                        mainMenu.setEnableFileManagers(true);
                        mainMenu.setEnableShowResults(true);
                        BuildProgramMenu.this.splashing.doneSomething("");
                        BuildProgramMenu.this.splashThread.setInterval(0);
                        matrices = showdb.getMatrices();
                        codons = showdb.getCodonUsage();
                        new JLabel("<html>");
                        return null;
                    }
                };
                databaseworker.start();
                BuildProgramMenu.this.splashing.doneSomething("");
                try {
                    try {
                        Hashtable hwoss = new JembossJarUtil("resources/wossname.jar").getHash();
                        if (hwoss.containsKey("wossname.out")) {
                            this.woss = new String((byte[])hwoss.get("wossname.out"));
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (this.woss.equals("")) {
                        GetWossname ewoss = new GetWossname(mysettings);
                        this.woss = ewoss.getWossnameText();
                        mainMenu.setEnableFileManagers(true);
                        mainMenu.setEnableShowResults(true);
                    }
                    BuildProgramMenu.this.splashing.doneSomething("");
                }
                catch (Exception e) {
                    BuildProgramMenu.this.splashing.doneSomething("Cannot connect!");
                    ServerSetup ss = new ServerSetup(mysettings);
                    int sso = JOptionPane.showConfirmDialog(f, ss, "Check Settings", 2, 0, null);
                    if (sso == 0) {
                        ss.setNewSettings();
                    }
                    System.exit(0);
                }
            }

            private void constructWithoutSoap() {
                String embossCommand;
                String embossBin = mysettings.getEmbossBin();
                RunEmbossApplication2 rea = null;
                try {
                    embossCommand = new String(embossBin + "wossname -colon -gui -auto");
                    rea = new RunEmbossApplication2(embossCommand, envp, null);
                    if (rea.getStatus().equals("1")) {
                        String error = rea.getInitialIOError();
                        JOptionPane.showMessageDialog(null, "Problem while getting emboss application list:\n" + error, "alert", 0);
                        return;
                    }
                    rea.waitFor();
                    this.woss = rea.getProcessStdout();
                }
                catch (RuntimeException e) {
                    try {
                        System.err.println(rea.getProcessStderr());
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(null, "Problem while getting emboss application list:" + e.getMessage(), "alert", 0);
                    return;
                }
                embossCommand = new String(embossBin + "showdb -auto");
                rea = new RunEmbossApplication2(embossCommand, envp, null);
                rea.waitFor();
                String showdbOut = rea.getProcessStdout();
                Database d = new Database(showdbOut);
                BuildProgramMenu.access$402(d.getDB());
                BuildProgramMenu.setMatrices(mysettings);
                BuildProgramMenu.setCoddonUsage(mysettings);
            }

            public void finished() {
                MultiLineToolTipUI.initialize();
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setDismissDelay(80000);
                try {
                    BuildProgramMenu.this.acdStore = new JembossJarUtil("resources/acdstore.jar").getHash();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                JMenuBar menuBar = new JMenuBar();
                this.progs = new ProgList(this.woss, menuBar);
                if (withSoap) {
                    BuildProgramMenu.this.splashing.doneSomething("");
                }
                int npG = this.progs.getNumPrimaryGroups();
                menuBar.setLayout(new GridLayout(npG, 1));
                int numProgs = this.progs.getNumProgs();
                String[] allAcd = this.progs.getProgsList();
                String[] allDes = this.progs.getProgDescription();
                menuPane.add((Component)menuBar, "North");
                this.favourites(allAcd, allDes, numProgs);
                this.constructProgramMenu(allAcd, numProgs);
                JList progList = this.constructScrollList(allAcd, numProgs);
                this.constructSearchToolbar(progList);
                f.validate();
            }

            private void favourites(final String[] allAcd, final String[] allDes, final int numProgs) {
                BuildProgramMenu.this.favorites = new Favorites(mainMenu.getFavoriteJMenu());
                JMenuItem[] favItems = BuildProgramMenu.this.favorites.getFavorites();
                for (int i = 0; i < favItems.length; ++i) {
                    favItems[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            f.setCursor(cbusy);
                            if (e.getActionCommand().equals("ADD") && BuildProgramMenu.this.currentApp > -1) {
                                JMenuItem favItem = BuildProgramMenu.this.favorites.add(allAcd[BuildProgramMenu.this.currentApp], allDes[BuildProgramMenu.this.currentApp]);
                                favItem.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        f.setCursor(cbusy);
                                        BuildProgramMenu.this.currentApp = this.setForm(e, numProgs, allAcd);
                                        f.setCursor(cdone);
                                    }
                                });
                            } else if (e.getActionCommand().equals("EDIT")) {
                                BuildProgramMenu.this.favorites.edit(allAcd);
                            } else {
                                BuildProgramMenu.this.currentApp = this.setForm(e, numProgs, allAcd);
                            }
                            f.setCursor(cdone);
                        }
                    });
                }
            }

            private void constructProgramMenu(final String[] allAcd, final int numProgs) {
                JMenuItem[] mi = new JMenuItem[numProgs];
                mi = this.progs.getMenuItems();
                int nm = this.progs.getNumberMenuItems();
                for (int i = 0; i < nm; ++i) {
                    JFrame splashf;
                    mi[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            f.setCursor(cbusy);
                            BuildProgramMenu.this.currentApp = this.setForm(e, numProgs, allAcd);
                            f.setCursor(cdone);
                        }
                    });
                    if (!withSoap || !(splashf = BuildProgramMenu.this.splashing.getSplashFrame()).isVisible()) continue;
                    splashf.toFront();
                }
            }

            private JList constructScrollList(final String[] allAcd, final int numProgs) {
                final JList<String> progList = new JList<String>(allAcd);
                JScrollPane scrollPane = new JScrollPane(progList);
                Box alphaPane = new Box(1);
                alphaPane.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                Box alphaTextPane = new Box(0);
                alphaPane.add(Box.createRigidArea(new Dimension(0, 10)));
                alphaTextPane.add(new JLabel("GoTo:"));
                alphaTextPane.add(Box.createRigidArea(new Dimension(5, 0)));
                final JTextField alphaTextPaneEntry = new JTextField(12);
                alphaTextPaneEntry.setMaximumSize(new Dimension(100, 20));
                alphaTextPaneEntry.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent e) {
                        this.updateScroll();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        this.updateScroll();
                    }

                    public void changedUpdate(DocumentEvent e) {
                    }

                    public void updateScroll() {
                        for (int k = 0; k < numProgs; ++k) {
                            if (!allAcd[k].startsWith(alphaTextPaneEntry.getText())) continue;
                            progList.ensureIndexIsVisible(k);
                            progList.setSelectionBackground(Color.cyan);
                            progList.setSelectedIndex(k);
                            break;
                        }
                    }
                });
                alphaTextPaneEntry.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        f.setCursor(cbusy);
                        int index = progList.getSelectedIndex();
                        BuildProgramMenu.this.currentApp = index;
                        this.setForm(index);
                        f.setCursor(cdone);
                    }
                });
                alphaTextPane.add(alphaTextPaneEntry);
                alphaPane.add(alphaTextPane);
                alphaPane.add(scrollPane);
                menuPane.add((Component)alphaPane, "Center");
                Dimension dp1 = menuPane.getMinimumSize();
                menuPane.setPreferredSize(dp1);
                menuPane.setMaximumSize(new Dimension(dp1.width, Short.MAX_VALUE));
                menuPane.setMinimumSize(dp1);
                scrollProgForm.setBackground(Color.white);
                progList.setSelectionBackground(Color.cyan);
                MouseAdapter mouseListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        f.setCursor(cbusy);
                        JList source = (JList)e.getSource();
                        source.setSelectionBackground(Color.cyan);
                        int index = source.getSelectedIndex();
                        BuildProgramMenu.this.currentApp = index;
                        this.setForm(index);
                        f.setCursor(cdone);
                    }
                };
                progList.addMouseListener(mouseListener);
                progList.addKeyListener(new ProgListSelectionListener());
                return progList;
            }

            private void constructSearchToolbar(JList progList) {
                final JRadioButton radioAND = new JRadioButton("AND");
                JRadioButton radioOR = new JRadioButton("OR");
                Font fnt = new Font("SansSerif", 1, 10);
                radioAND.setFont(fnt);
                radioOR.setFont(fnt);
                radioAND.setSelected(true);
                ButtonGroup group = new ButtonGroup();
                group.add(radioAND);
                group.add(radioOR);
                JToolBar toolBar = new JToolBar(1);
                final JTextField search = new JTextField(12);
                search.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new KeywordSearch(search, woss, mysettings, withSoap, radioAND.isSelected());
                    }
                });
                Box bacross = Box.createHorizontalBox();
                JLabel keyw = new JLabel("Keyword Search");
                keyw.setFont(fnt);
                bacross.add(keyw);
                JButton go = new JButton("GO");
                go.setFont(new Font("monospaced", 1, 10));
                go.setMargin(new Insets(0, 0, 0, 0));
                go.setForeground(new Color(0, 51, 102));
                go.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new KeywordSearch(search, woss, mysettings, withSoap, radioAND.isSelected());
                    }
                });
                bacross.add(Box.createHorizontalStrut(2));
                bacross.add(go);
                bacross.add(Box.createHorizontalGlue());
                toolBar.add(bacross);
                toolBar.add(search);
                bacross = Box.createHorizontalBox();
                bacross.add(radioAND);
                bacross.add(radioOR);
                bacross.add(Box.createHorizontalGlue());
                toolBar.add(bacross);
                menuPane.add((Component)toolBar, "South");
            }

            private void putJembossLogo() {
                ClassLoader cl = this.getClass().getClassLoader();
                ImageIcon jlo = new ImageIcon(cl.getResource("images/Jemboss_logo_large.gif"));
                JLabel jlablogo = new JLabel(jlo);
                formPane.add((Component)jlablogo, "Center");
                formPane.setBackground(Color.white);
            }

            private void setForm(int i) {
                formPane.removeAll();
                String acdText = BuildProgramMenu.this.getAcdText(this.progs.getProgsList()[i], mysettings, withSoap);
                new BuildJembossForm(this.progs.getProgDescription()[i], db, this.progs.getProgsList()[i], envp, cwd, acdText, withSoap, formPane, mysettings, f);
                JScrollBar verticalScrollBar = scrollProgForm.getVerticalScrollBar();
                JScrollBar horizontalScrollBar = scrollProgForm.getHorizontalScrollBar();
                verticalScrollBar.setValue(verticalScrollBar.getMinimum());
                horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
                f.repaint();
            }

            private int setForm(ActionEvent e, int numProgs, String[] allAcd) {
                String p = e.getActionCommand();
                int ind = p.indexOf(" ");
                if (ind > -1) {
                    p = p.substring(0, ind).trim();
                }
                for (int k = 0; k < numProgs; ++k) {
                    if (!p.equalsIgnoreCase(allAcd[k])) continue;
                    BuildProgramMenu.this.currentApp = k;
                    this.setForm(k);
                    break;
                }
                return BuildProgramMenu.this.currentApp;
            }

            final class ProgListSelectionListener
            implements KeyListener {
                ProgListSelectionListener() {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        JList l = (JList)e.getSource();
                        this.setForm(l.getSelectedIndex());
                    }
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            }
        };
        groupworker.start();
    }

    protected static String[] getDatabaseList() {
        return db;
    }

    public static Vector getMatrices() {
        return matrices;
    }

    private static Set matrixIndicies(String filename) {
        HashSet<String> s = new HashSet<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#") && line.length() > 0) {
                    String m = line.split(" ")[0];
                    s.add(m);
                }
                line = in.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void setMatrices(JembossParams mysettings) {
        final Set s = BuildProgramMenu.matrixIndicies(mysettings.getEmbossData() + File.separator + "Matrices.protein");
        s.addAll(BuildProgramMenu.matrixIndicies(mysettings.getEmbossData() + File.separator + "Matrices.nucleotide"));
        s.addAll(BuildProgramMenu.matrixIndicies(mysettings.getEmbossData() + File.separator + "Matrices.proteinstructure"));
        Object[] dataFile = new File(mysettings.getEmbossData()).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (s.contains(name)) {
                    s.remove(name);
                    return true;
                }
                return false;
            }
        });
        if (s.size() > 0) {
            System.err.println("matrices not resolved to any file: " + s.size());
        }
        matrices = new Vector();
        Arrays.sort(dataFile);
        for (int i = 0; i < dataFile.length; ++i) {
            matrices.add(dataFile[i]);
        }
    }

    public static Vector getCodonUsage() {
        return codons;
    }

    public static void setCoddonUsage(JembossParams mysettings) {
        String[] dataFile = new File(mysettings.getEmbossData() + File.separator + "CODONS").list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File fileName = new File(dir, name);
                return !fileName.isDirectory();
            }
        });
        codons = new Vector();
        for (int i = 0; i < dataFile.length; ++i) {
            codons.add(dataFile[i]);
        }
    }

    private String getAcdText(String applName, JembossParams mysettings, boolean withSoap) {
        String acdText = new String("");
        if (!withSoap) {
            String acdDirToParse = mysettings.getAcdDirToParse();
            String acdToParse = acdDirToParse.concat(applName).concat(".acd");
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(acdToParse));
                StringBuffer buff = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    buff = buff.append(line + "\n");
                }
                in.close();
                acdText = buff.toString();
            }
            catch (IOException e) {
                System.err.println("BuildProgramMenu: Cannot read acd file " + acdToParse);
            }
        } else if (this.acdStore.containsKey(applName + ".acd")) {
            Object obj = this.acdStore.get(applName + ".acd");
            acdText = obj.getClass().getName().equals("java.lang.String") ? (String)obj : new String((byte[])obj);
        } else {
            GetACD progacd = new GetACD(applName, mysettings);
            acdText = progacd.getAcd();
            this.acdStore.put(applName + ".acd", acdText);
        }
        return acdText;
    }

    public static String[] getEnvp() {
        return envp;
    }

    static /* synthetic */ String[] access$402(String[] x0) {
        db = x0;
        return x0;
    }
}

