/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.www.protocol.https.Handler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Security;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.emboss.jemboss.JembossJarUtil;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.BuildProgramMenu;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.LocalTreeToolBar;
import org.emboss.jemboss.soap.PendingResults;

public class Jemboss
implements ActionListener {
    private JFrame f;
    private JSplitPane pmain;
    private JPanel localFileManagerPanel;
    public static DragTree tree;
    private JButton extend;
    private JScrollPane scrollTree;
    public static boolean withSoap;
    public static PendingResults resultsManager;
    private ImageIcon displayFileManager;
    private ImageIcon hideFileManager;
    private SetUpMenuBar mainMenu;
    final String fileseparator = System.getProperty("file.separator");
    public static final int DEFAULT_WINDOW_X = 50;
    public static final int DEFAULT_WINDOW_Y = 50;
    public static final int DEFAULT_WINDOW_WIDTH = 300;
    public static final int DEFAULT_WINDOW_HEIGHT = 100;
    public static final String WINDOW_X_KEY = "JEMBOSS_WINDOW_X";
    public static final String WINDOW_Y_KEY = "JEMBOSS_WINDOW_Y";
    public static final String WINDOW_WIDTH_KEY = "JEMBOSS_WINDOW_WIDTH";
    public static final String WINDOW_HEIGHT_KEY = "JEMBOSS_WINDOW_HEIGHT";
    public static final String DIVIDER1_LOCATION_KEY = "JEMBOSS_DIVIDER1_LOCATION";
    public static final String DIVIDER2_LOCATION_KEY = "JEMBOSS_DIVIDER2_LOCATION";
    public static final String LOCAL_FILE_MAN_KEY = "LOCAL_FILE_MANAGER";
    private Preferences myPreferences = null;
    JPanel menuPanel;
    JSplitPane pright;
    JPanel pform;

    public Jemboss() {
        JembossParams mysettings = new JembossParams();
        if (!JembossParams.isJembossServer()) {
            withSoap = false;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        this.displayFileManager = new ImageIcon(cl.getResource("images/Forward_arrow_button.gif"));
        this.hideFileManager = new ImageIcon(cl.getResource("images/Backward_arrow_button.gif"));
        if (withSoap && mysettings.getPublicSoapURL().startsWith("https")) {
            Provider p = new Provider();
            Security.addProvider((java.security.Provider)p);
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (protocol != null && protocol.compareTo("https") == 0) {
                        return new Handler();
                    }
                    return null;
                }
            });
            System.setProperty("javax.net.ssl.trustStore", "resources/client.keystore");
            String jembossClientKeyStore = System.getProperty("user.home") + this.fileseparator + ".jembossClientKeystore";
            try {
                new JembossJarUtil("resources/client.jar").writeByteFile("client.keystore", jembossClientKeyStore);
                System.setProperty("javax.net.ssl.trustStore", jembossClientKeyStore);
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        this.f = new JFrame("Jemboss");
        this.f.addWindowListener(new winExit());
        this.checkHomeDirectories(mysettings);
        this.initMainFrame(mysettings);
    }

    private void checkHomeDirectories(JembossParams mysettings) {
        if (!withSoap && mysettings.getUserHome().equals(System.getProperty("user.home"))) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                String emboss_root = System.getenv().get("EMBOSS_ROOT");
                String userhome = emboss_root + this.fileseparator + System.getProperty("user.name");
                String resultshome = userhome + this.fileseparator + "results";
                File rh = new File(resultshome);
                if (!rh.exists() && !rh.mkdirs()) {
                    JOptionPane.showMessageDialog(this.f, "Jemboss not able to set its results directory to the following location:\n" + resultshome, "Message", 1);
                }
                if (rh.exists()) {
                    mysettings.setUserHome(userhome);
                    mysettings.setResultsHome(resultshome);
                }
            } else {
                mysettings.setUserHome(System.getProperty("user.dir"));
            }
            if (mysettings.getDebug()) {
                System.out.println("Standalone mode");
            }
        }
    }

    private void initMainFrame(JembossParams mysettings) {
        tree = new DragTree(new File(mysettings.getUserHome()), this.f, mysettings);
        JPanel filePanel = new JPanel(new BorderLayout());
        filePanel.add((Component)new LocalTreeToolBar(mysettings), "North");
        filePanel.add((Component)tree, "Center");
        this.scrollTree = new JScrollPane(filePanel);
        this.menuPanel = new JPanel(new BorderLayout());
        JPanel embossFormPanel = new JPanel(new GridLayout());
        this.localFileManagerPanel = new JPanel(new BorderLayout());
        this.localFileManagerPanel.add(this.scrollTree);
        JScrollPane scrollProgForm = new JScrollPane(embossFormPanel);
        scrollProgForm.setBackground(Color.white);
        this.pform = new JPanel(new BorderLayout());
        this.pform.add((Component)scrollProgForm, "Center");
        this.pright = new JSplitPane();
        this.pright.setLeftComponent(this.pform);
        this.localFileManagerPanel.add(this.scrollTree);
        this.pright.setRightComponent(null);
        this.pright.setDividerSize(0);
        JMenuBar btmMenu = new JMenuBar();
        this.extend = new JButton(this.displayFileManager);
        this.extend.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.black));
        this.extend.addActionListener(this);
        this.extend.setToolTipText("Open file manager.");
        resultsManager = new PendingResults(mysettings, withSoap);
        btmMenu.add(resultsManager.statusPanel(this.f));
        btmMenu.add(this.extend);
        this.pform.add((Component)btmMenu, "South");
        this.pmain = new JSplitPane(1, this.menuPanel, this.pright);
        this.mainMenu = new SetUpMenuBar(mysettings, this.f, withSoap);
        new BuildProgramMenu(this.menuPanel, embossFormPanel, this.pform, scrollProgForm, mysettings, withSoap, this.mainMenu, this.f);
        this.setWindowSizesAndLocation();
    }

    private void setWindowSizesAndLocation() {
        Dimension screensize = this.f.getToolkit().getScreenSize();
        this.myPreferences = Preferences.userNodeForPackage(Jemboss.class);
        if (screensize.getWidth() < 1024.0) {
            this.menuPanel.setPreferredSize(new Dimension(130, 500));
            this.pform.setPreferredSize(new Dimension(500, 500));
            this.localFileManagerPanel.setPreferredSize(new Dimension(180, 500));
        } else {
            this.menuPanel.setPreferredSize(new Dimension(140, 500));
            this.pform.setPreferredSize(new Dimension(520, 540));
            this.localFileManagerPanel.setPreferredSize(new Dimension(200, 540));
        }
        this.pform.setMinimumSize(this.pform.getPreferredSize());
        this.menuPanel.validate();
        int a = this.menuPanel.getPreferredSize().width;
        this.pmain.setDividerLocation(this.myPreferences.getInt(DIVIDER1_LOCATION_KEY, a));
        if (this.myPreferences.getBoolean(LOCAL_FILE_MAN_KEY, false)) {
            this.pright.setRightComponent(this.localFileManagerPanel);
            this.pright.setDividerLocation(this.myPreferences.getInt(DIVIDER2_LOCATION_KEY, 300));
            this.extend.setIcon(this.hideFileManager);
            this.extend.setToolTipText("Close file manager.");
        }
        this.f.setContentPane(this.pmain);
        this.f.validate();
        this.f.pack();
        int x = this.myPreferences.getInt(WINDOW_X_KEY, 0);
        int y = (screensize.height - this.f.getPreferredSize().height) / 2;
        y = this.myPreferences.getInt(WINDOW_Y_KEY, y);
        int width = this.myPreferences.getInt(WINDOW_WIDTH_KEY, this.pmain.getWidth() + 10);
        int height = this.myPreferences.getInt(WINDOW_HEIGHT_KEY, this.pmain.getHeight() + 10);
        this.f.setBounds(x, y, width, height);
        this.f.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.extend.getIcon() == this.hideFileManager) {
            this.extend.setIcon(this.displayFileManager);
            this.extend.setToolTipText("Open file manager.");
            this.pright.setRightComponent(null);
            this.pform.setPreferredSize(new Dimension(this.pform.getPreferredSize().width, this.pform.getHeight()));
            this.f.pack();
            this.localFileManagerPanel.setPreferredSize(this.localFileManagerPanel.getSize());
        } else {
            this.extend.setIcon(this.hideFileManager);
            this.extend.setToolTipText("Close file manager.");
            this.pright.setRightComponent(this.localFileManagerPanel);
            this.pright.validate();
            this.pform.setPreferredSize(new Dimension(this.pform.getPreferredSize().width, this.pform.getHeight()));
            this.f.pack();
        }
    }

    public static void main(String[] args) {
        withSoap = args.length > 0 ? !args[0].equalsIgnoreCase("local") : true;
        new Jemboss();
    }

    class winExit
    extends WindowAdapter {
        winExit() {
        }

        public void windowClosing(WindowEvent we) {
            Jemboss.this.myPreferences.putInt(Jemboss.WINDOW_WIDTH_KEY, Jemboss.this.f.getWidth());
            Jemboss.this.myPreferences.putInt(Jemboss.WINDOW_HEIGHT_KEY, Jemboss.this.f.getHeight());
            Jemboss.this.myPreferences.putInt(Jemboss.WINDOW_X_KEY, Jemboss.this.f.getX());
            Jemboss.this.myPreferences.putInt(Jemboss.WINDOW_Y_KEY, Jemboss.this.f.getY());
            Jemboss.this.myPreferences.putInt(Jemboss.DIVIDER1_LOCATION_KEY, Jemboss.this.pmain.getDividerLocation());
            Jemboss.this.myPreferences.putInt(Jemboss.DIVIDER2_LOCATION_KEY, Jemboss.this.pright.getDividerLocation());
            Jemboss.this.myPreferences.putBoolean(Jemboss.LOCAL_FILE_MAN_KEY, Jemboss.this.pright.getRightComponent() != null);
            Jemboss.this.mainMenu.exitJemboss();
        }
    }
}

