# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core.backend import Backend
from elisa.core.frontend import Frontend
from elisa.core.common import application

class SwitchThemeAction(Action):
    """
    DOCME
    """
    
    theme_path = None

    label = 'switch theme action'
    
    def __call__(self, controller, origin):
        if isinstance(origin, Backend):
            for frontend in origin.frontends:
                self._set_frontend_theme(frontend, self.theme_path)
        elif isinstance(origin, Frontend):
            self._set_frontend_theme(origin, self.theme_path)
        else:
            raise Exception("Cannot change the theme because origin of the \
                             event is unknown")

    def _set_frontend_theme(self, frontend, theme_path):
        theme = application.plugin_registry.create_component(theme_path)
        frontend.theme = theme
        application.config.set_option('theme', theme_path,
                                      section=frontend.name)
