
from node_builder_test import NodeBuilderTest, StupidModel
from elisa.core.tests.elisa_test_case import ElisaTestCase

from elisa.extern.coherence.et import parse_xml

import os

class StupidActivity(object):
    # Ugly Hack!
    player_model = None

class ActivityNodeBuilderTest(NodeBuilderTest, ElisaTestCase):
    component_path = 'xmlmenu:activity_node_builder'
    entry_identifiers = ['activity_node']

    def test_get_entries(self):
        data = """
            <MenuEntry type='activity_node'>
                <Label translate-domain='elisa-base'>Services</Label>
                <Icon>services_icon</Icon>
                <Activity>base:service_activity</Activity>
            </MenuEntry>
            """
        
        xml = parse_xml(data)
        test_entry = xml.getroot()

        def done_callback(data):
            self.assertEquals(len(data), 1)
            service_model = data[0]
            self.assertEquals(service_model.theme_icon,'service_icon')
            self.failIf(service_model.activity == self.component)
        
        test_model = StupidModel()
        test_model.activity = StupidActivity()
        dfr = self.component.build_menu_entry(test_model, test_entry)
        dfr.addCallback(done_callback)
        return dfr

    def test_missing_activity_name(self):
        data = """
            <MenuEntry type='activity_node'>
                <Label translate-domain='elisa-base'>Services</Label>
                <Icon>services_icon</Icon>
            </MenuEntry>
            """
        
        xml = parse_xml(data)
        test_entry = xml.getroot()

        def done_callback(data):
            self.assertEquals(len(data), 0)
        
        test_model = StupidModel()
        test_model.activity = StupidActivity()
        dfr = self.component.build_menu_entry(test_model, test_entry)
        dfr.addCallback(done_callback)
        return dfr

    def test_wrong_activity(self):
        data = """
            <MenuEntry type='activity_node'>
                <Label translate-domain='elisa-base'>Services</Label>
                <Icon>services_icon</Icon>
                <Activity>foo:bar_acitivity_that_is_missing</Activity>
            </MenuEntry>
            """
        
        xml = parse_xml(data)
        test_entry = xml.getroot()

        def done_callback(data):
            self.assertEquals(len(data), 0)
        
        test_model = StupidModel()
        test_model.activity = StupidActivity()
        dfr = self.component.build_menu_entry(test_model, test_entry)
        dfr.addCallback(done_callback)
        return dfr

    # FIXME: add a test for the menu_model wrapping



