-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkCurve objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_curve_writer.e,v 1.4 2000/07/10 11:31:12 elphick Exp $"

class GTK_CURVE_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is
		once
			Result := "GTK_CURVE"
		end
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			curve_type := widget_tree.get_string_from_field("curve_type")
			min_x := widget_tree.get_real_string_from_field("min_x")
			max_x := widget_tree.get_real_string_from_field("max_x")
			min_y := widget_tree.get_real_string_from_field("min_y")
			max_y := widget_tree.get_real_string_from_field("max_y")
		end
			
	curve_type: STRING
	min_x: STRING
	max_x: STRING
	min_y: STRING
	max_y: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_curve_type(" + curve_type + ")")
			code.add_last(name + ".set_range(" + min_x + ", " + max_x + ", " + min_y + ", " + max_y + ")")
			add_widget_code(code)
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!Result.make
			!!temp.make_with_name("GTK_CURVE_EXTERNALS")
			temp.add_undefine_clause("copy, is_equal")
			Result.add(temp)
		end
			
end
