-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

   description:  "Features that must be accessed from several classes"
   author:  "Oliver Elphick <olly@lfix.co.uk>"
   date:    "31 October 1999"
   cvs:     "$Id: globals.e,v 1.6 2001/01/09 15:04:57 elphick Exp $"

class GLOBALS

feature

   project_file: STRING is
      once
	 !!Result.make(0)
      end

   set_project_file (s: STRING) is
      require
	 good_file: s /= Void and then not s.is_empty
      do
	 project_file.make_from_string(s)
      ensure
	 file_set: project_file.is_equal(s)
      end

   project_name: STRING is
      once
	 !!Result.make(0)
      end

   set_project_name (s: STRING) is
      require
	 good_name: s /= Void and then not s.is_empty
      do
	 project_name.make_from_string(s)
      ensure
	 name_set: project_name.is_equal(s)
      end
	 
   is_vegtk: BOOLEAN is
      once
	 Result := false
      end

   root_name: STRING is
      once
	 !!Result.make(0)
      end

   root_file: STRING is
      once
	 !!Result.make(0)
      end

end -- GLOBALS
