-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Template for all class writers"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: class_writer.e,v 1.16 2001/01/09 15:04:57 elphick Exp $"

deferred class CLASS_WRITER

inherit

	CONTAINER

	CLASS_INDEX

feature

	inherit_from: STRING is
		deferred
		end

	inherit_klass: KLASS is
		do
			!!Result.make_with_name(inherit_from)
		end

	write_inherit is
		do
			if not inherit_list.empty then
				write_line("inherit")
				indent
				blank_line
				write_lines(inherit_list.get_array)
				outdent
				blank_line
			end
		ensure
			indentation_restored: indentation = old indentation
		end

	inherit_list: INHERIT_LIST

	write_make_body is
		deferred
		ensure
			indentation_restored: indentation = old indentation
		end
		
	write_features is
		deferred
		ensure
			indentation_restored: indentation = old indentation
		end
		
	write_creation is
		do
			write_line("creation")
			blank_line
			indent
			write_line("make")
			outdent
			blank_line
		ensure
			indentation_restored: indentation = old indentation
		end

	write_class is
		do
			print("Writing ")
			print(filename)
			print("%N")
			!!file.connect_to(filename)
			write_line("indexing")
			blank_line
			indent
			write_line("description: %""+ classname +"%"")
			write_line("generated_by: %"eglade " + version + "%"")
			write_line("project_file: %"" + project_file + "%"")
			write_line("date: %"" + gendate +"%"")
			write_line(regeneration_status)
			write_line("cvs: %"$I" + "d$%"")
			outdent
			blank_line
			write_line("class "+classname)
			blank_line
			write_inherit
			write_creation
			write_line("feature")
			blank_line
			indent
			write_features
			blank_line
			write_make_body
			outdent
			blank_line
			write_line("end -- " + classname)
			file.disconnect
		end

	regeneration_status: STRING is
		do
			Result := "on_regeneration: %"This class text will be overwritten%""
		ensure
			Result /= Void and then not Result.is_empty
		end

	gendate: STRING is
			-- date and time of generating the program
		local
			date: DATE
		once
			!!date
			Result := clone(date.now)
		ensure
			date_set: Result /= Void and then not Result.is_empty
		end

end
