/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "show_actual_montage_dialog.h"




UI_ShowActualMontagewindow::UI_ShowActualMontagewindow(QWidget *parent)
{
  int i, j,
      type,
      model,
      order;

  char txtbuf[2048];

  double frequency,
         frequency2,
         ripple;


  mainwindow = (UI_Mainwindow *)parent;

  ShowMontageDialog = new QDialog;

  ShowMontageDialog->setMinimumSize(QSize(800, 300));
  ShowMontageDialog->resize(600, 440);
  ShowMontageDialog->setWindowTitle("Show montage");
  ShowMontageDialog->setModal(TRUE);
  ShowMontageDialog->setAttribute(Qt::WA_DeleteOnClose, TRUE);

  textedit1 = new QTextEdit;
  textedit1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  textedit1->setReadOnly(TRUE);
  textedit1->setLineWrapMode(QTextEdit::NoWrap);
  textedit1->setFont(*mainwindow->monofont);

  CloseButton = new QPushButton;
  CloseButton->setFixedSize(100, 25);
  CloseButton->setText("Close");

  box = new QBoxLayout(QBoxLayout::TopToBottom, ShowMontageDialog);
  box->addWidget(textedit1);
  box->addWidget(CloseButton, 0, Qt::AlignRight);

  QObject::connect(CloseButton,  SIGNAL(clicked()), ShowMontageDialog, SLOT(close()));

  for(i=0; i<mainwindow->signalcomps; i++)
  {
    sprintf(txtbuf, "%3i: ", i + 1);

    for(j=0; j<mainwindow->signalcomp[i]->num_of_signals; j++)
    {
      sprintf(txtbuf + strlen(txtbuf), "%+ix %s",
              mainwindow->signalcomp[i]->factor[j],
              mainwindow->signalcomp[i]->edfhdr->edfparam[mainwindow->signalcomp[i]->edfsignal[j]].label);

      remove_trailing_spaces(txtbuf);

      strcat(txtbuf, " ");
    }

    for(j=0; j<mainwindow->signalcomp[i]->filter_cnt; j++)
    {
      if(mainwindow->signalcomp[i]->filter[j]->is_LPF == 1)
      {
        sprintf(txtbuf + strlen(txtbuf), "LPF: %fHz  ", mainwindow->signalcomp[i]->filter[j]->cutoff_frequency);
      }

      if(mainwindow->signalcomp[i]->filter[j]->is_LPF == 0)
      {
        sprintf(txtbuf + strlen(txtbuf), "HPF: %fHz  ", mainwindow->signalcomp[i]->filter[j]->cutoff_frequency);
      }
    }

    for(j=0; j<mainwindow->signalcomp[i]->fidfilter_cnt; j++)
    {
      type = mainwindow->signalcomp[i]->fidfilter_type[j];

      model = mainwindow->signalcomp[i]->fidfilter_model[j];

      frequency = mainwindow->signalcomp[i]->fidfilter_freq[j];

      frequency2 = mainwindow->signalcomp[i]->fidfilter_freq2[j];

      order = mainwindow->signalcomp[i]->fidfilter_order[j];

      ripple = mainwindow->signalcomp[i]->fidfilter_ripple[j];

      if(type == 0)
      {
        if(model == 0)
        {
          sprintf(txtbuf + strlen(txtbuf), "highpass Butterworth %fHz %ith order  ", frequency, order);
        }

        if(model == 1)
        {
          sprintf(txtbuf + strlen(txtbuf), "highpass Chebyshev %fHz %ith order %fdB ripple  ", frequency, order, ripple);
        }

        if(model == 2)
        {
          sprintf(txtbuf + strlen(txtbuf), "highpass Bessel %fHz %ith order  ", frequency, order);
        }
      }

      if(type == 1)
      {
        if(model == 0)
        {
          sprintf(txtbuf + strlen(txtbuf), "lowpass Butterworth %fHz %ith order  ", frequency, order);
        }

        if(model == 1)
        {
          sprintf(txtbuf + strlen(txtbuf), "lowpass Chebyshev %fHz %ith order %fdB ripple  ", frequency, order, ripple);
        }

        if(model == 2)
        {
          sprintf(txtbuf + strlen(txtbuf), "lowpass Bessel %fHz %ith order  ", frequency, order);
        }
      }

      if(type == 2)
      {
        sprintf(txtbuf + strlen(txtbuf), "notch %fHz Q-factor %i  ", frequency, order);
      }

      if(type == 3)
      {
        if(model == 0)
        {
          sprintf(txtbuf + strlen(txtbuf), "bandpass Butterworth %f-%fHz %ith order  ", frequency, frequency2, order);
        }

        if(model == 1)
        {
          sprintf(txtbuf + strlen(txtbuf), "bandpass Chebyshev %f-%fHz %ith order %fdB ripple  ", frequency, frequency2, order, ripple);
        }

        if(model == 2)
        {
          sprintf(txtbuf + strlen(txtbuf), "bandpass Bessel %f-%fHz %ith order  ", frequency, frequency2, order);
        }
      }

      if(type == 4)
      {
        if(model == 0)
        {
          sprintf(txtbuf + strlen(txtbuf), "bandstop Butterworth %f-%fHz %ith order  ", frequency, frequency2, order);
        }

        if(model == 1)
        {
          sprintf(txtbuf + strlen(txtbuf), "bandstop Chebyshev %f-%fHz %ith order %fdB ripple  ", frequency, frequency2, order, ripple);
        }

        if(model == 2)
        {
          sprintf(txtbuf + strlen(txtbuf), "bandstop Bessel %f-%fHz %ith order  ", frequency, frequency2, order);
        }
      }
    }

    sprintf(txtbuf + strlen(txtbuf), " %f", mainwindow->signalcomp[i]->voltpercm);

    strcat(txtbuf, mainwindow->signalcomp[i]->edfhdr->edfparam[mainwindow->signalcomp[i]->edfsignal[0]].physdimension);

    remove_trailing_spaces(txtbuf);

    sprintf(txtbuf + strlen(txtbuf), "/cm offset: %f", mainwindow->signalcomp[i]->screen_offset * mainwindow->pixelsizefactor * mainwindow->signalcomp[i]->voltpercm);

    strcat(txtbuf, mainwindow->signalcomp[i]->edfhdr->edfparam[mainwindow->signalcomp[i]->edfsignal[0]].physdimension);

    remove_trailing_spaces(txtbuf);

    remove_trailing_zeros(txtbuf);

    textedit1->append(txtbuf);
  }

  ShowMontageDialog->exec();
}














