#!/bin/sh
#
# LIB DEP 0.3 - The library dependencies checker.
# This will create a LIBS and CFLAGS line in 2 files for output
# in the Makefile
#
# Makefile.libdep should have the rest of the Makefile
#
# Syntax: libdep.sh <library name> <cflags to add> <libs to add> [-fail [reason] | [-clean]]
#
# (C) 1999 Patrick Lambert - Provided under the GPL license
# 

TEST="$1"
CFLAGS="$2"
LIBS="$3"
OPT="$4"
REASON="$5"
LDCONFIG=/sbin/ldconfig
TMP=.

if [ ! -e "$LDCONFIG" ]; then
 LDCONFIG=`which ldconfig`
fi


if [ "$OPT" = "-clean" ]; then
 rm -f .libdep.*
fi

if [ ! -e "$TMP/.libdep.tmp" ]; then
 echo "Reading current system configuration..."
 $LDCONFIG -v > $TMP/.libdep.tmp 2>&1
fi

echo -n "Checking for $TEST..."
TRY=`grep $TEST $TMP/.libdep.tmp`
if [ "$TRY" != "" ]; then
 echo -n "Found!"
 echo -n "$CFLAGS " >> $TMP/.libdep.cflags
 echo -n "$LIBS " >> $TMP/.libdep.libs
 SUCCESS="1"
fi
echo ""

if [ "$OPT" = "-fail" ]; then
 if [ "$REASON" != "" ]; then
  if [ "$SUCCESS" != "1" ]; then
   echo "FAILED: $REASON"
   exit 5
  fi
 fi
 if [ "$REASON" = "" ]; then
  if [ "$SUCCESS" != "1" ]; then
   echo "FAILED: This library is needed for libdep to continue."                                           
   exit 5
  fi
 fi
fi

