/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002-2004 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#ifndef _UTILS_H_
#define _UTILS_H_

#include "config.h"

#include <glib.h>
#include <glade/glade.h>

void
hash_table_item_free (gpointer data);

void
hash_table_clear (GHashTable *table);

gint
string_compare (gconstpointer a, gconstpointer b);

gchar*
unescape_text (const gchar *text);

GladeXML*
load_glade_xml (void);

gboolean
picture_exists (const gchar *config_dir, const gchar *pic_file);

#endif /* _UTILS_H_ */
