/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// ----------------------------------------------------------------------------------
//
// colourfilter, PRE filter for changing YCrCb colour values
// TODO : add RGB colour adjustment
//
// 11-08-2002 - Jarl van Katwijk
//
// ----------------------------------------------------------------------------------


#include "../config.h"
#include "../src/drip.h"
#include "../encoder/plugin-loader.hh"
#include <gmodule.h>

//#define DEBUG
#undef DEBUG

static gboolean init_done = FALSE;                 // Plugin initialised flag
static gint width,height;                          // Input Width\Height sizes
static gint xoff,yoff,xlen,ylen;                   // Offset and lenght values
static gdouble framerate;                           // Framerate (25.00, 29.97, etc)
static gdouble value1,value2,value3,value4,value5;  // Plugin defined values - these are loaded\saved by Drip
static guint8 *src_planes[3];                      // Input data planes (I420 colour space)
static guint8 *dst_planes[3];                      // Output data planes

extern "C" {


/* Return type (SPU,AUDIO,VIDEO) of filter */
G_MODULE_EXPORT module_type_e colourfilter_type(void) {
    return VIDEO;
}


/* Return phase (PRE,NORMAL,POST) of filter */
G_MODULE_EXPORT module_phase_e colourfilter_phase(void) {
    return NORMAL;
}


guint8 max255(guint value) {
    if (value<256) {
        return value;
    } else {
        return 255;
    }
}

/* Callbacks */
void cb_page_size_y( GtkAdjustment *get, GtkAdjustment *set ) {
    value1 = (guint)set->value; // Y adjustment
}

void cb_page_size_cr( GtkAdjustment *get, GtkAdjustment *set ) {
    value2 = (guint)set->value; // CR adjustment
}

void cb_page_size_cb( GtkAdjustment *get, GtkAdjustment *set ) {
    value3 = (guint)set->value; // CB adjustment
}



/* Function which implements a GtkPlug to let user configure this plugin */ 
G_MODULE_EXPORT GtkWidget* colourfilter_gui(void) {
    static GtkWidget *vbox16 = NULL;
    static GtkWidget *label16;
    static GtkWidget *hbox34;
    static GtkWidget *vbox17;
    static GtkWidget *vscale_Y;
    static GtkWidget *label17;
    static GtkWidget *vbox18;
    static GtkWidget *vscale_cr;
    static GtkWidget *label18;
    static GtkWidget *vbox19;
    static GtkWidget *vscale_cb;
    static GtkWidget *label19;
    static GtkObject *adjustment_y;
    static GtkObject *adjustment_cr;
    static GtkObject *adjustment_cb;

    #ifdef DEBUG
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: colourfilter gui");
    #endif

    /* Build the gtk user interface for this plugins here. Also implement the callbacks */
    vbox16 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox16);
    gtk_widget_show (vbox16);

    label16 = gtk_label_new ("\nColour Filter  -  Adjusts YCrCb colour of the video in %\n\n(100 = normal, 0 = none, 200 = double)\n");
    gtk_widget_ref (label16);
    gtk_widget_show (label16);
    gtk_box_pack_start (GTK_BOX (vbox16), label16, FALSE, FALSE, 0);

    hbox34 = gtk_hbox_new (TRUE, 0);
    gtk_widget_ref (hbox34);
    gtk_widget_show (hbox34);
    gtk_box_pack_start (GTK_BOX (vbox16), hbox34, TRUE, TRUE, 0);

    vbox17 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox17);
    gtk_widget_show (vbox17);
    gtk_box_pack_start (GTK_BOX (hbox34), vbox17, TRUE, TRUE, 0);

    adjustment_y = gtk_adjustment_new(value1, 0, 200, 1, 0, 0);
    vscale_Y = gtk_vscale_new (GTK_ADJUSTMENT (adjustment_y) );
    gtk_widget_ref (vscale_Y);
    gtk_widget_show (vscale_Y);
    gtk_box_pack_start (GTK_BOX (vbox17), vscale_Y, TRUE, TRUE, 0);
    gtk_scale_set_value_pos (GTK_SCALE (vscale_Y), GTK_POS_BOTTOM);

    label17 = gtk_label_new ("\nBrightness\n(Y plane)\n");
    gtk_widget_ref (label17);
    gtk_widget_show (label17);
    gtk_box_pack_start (GTK_BOX (vbox17), label17, FALSE, FALSE, 0);

    vbox18 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox18);
    gtk_widget_show (vbox18);
    gtk_box_pack_start (GTK_BOX (hbox34), vbox18, TRUE, TRUE, 0);

    adjustment_cr = gtk_adjustment_new (value2, 0, 200, 1, 0, 0);
    vscale_cr = gtk_vscale_new (GTK_ADJUSTMENT (adjustment_cr) );
    gtk_widget_ref (vscale_cr);
    gtk_widget_show (vscale_cr);
    gtk_box_pack_start (GTK_BOX (vbox18), vscale_cr, TRUE, TRUE, 0);
    gtk_scale_set_value_pos (GTK_SCALE (vscale_cr), GTK_POS_BOTTOM);

    label18 = gtk_label_new ("\nRed\n(Cr plane)\n");
    gtk_widget_ref (label18);
    gtk_widget_show (label18);
    gtk_box_pack_start (GTK_BOX (vbox18), label18, FALSE, FALSE, 0);
  
    vbox19 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox19);
    gtk_widget_show (vbox19);
    gtk_box_pack_start (GTK_BOX (hbox34), vbox19, TRUE, TRUE, 0);
  
    adjustment_cb = gtk_adjustment_new (value3, 0, 200, 1, 0, 0);
    vscale_cb = gtk_vscale_new (GTK_ADJUSTMENT (adjustment_cb) );
    gtk_widget_ref (vscale_cb);
    gtk_widget_show (vscale_cb);
    gtk_box_pack_start (GTK_BOX (vbox19), vscale_cb, TRUE, TRUE, 0);
    gtk_scale_set_value_pos (GTK_SCALE (vscale_cb), GTK_POS_BOTTOM);
  
    label19 = gtk_label_new ("\nBlue\n(Cb plane)\n");
    gtk_widget_ref (label19);
    gtk_widget_show (label19);
    gtk_box_pack_start (GTK_BOX (vbox19), label19, FALSE, FALSE, 0);
  
    gtk_signal_connect (GTK_OBJECT (adjustment_y), "value_changed",
                        GTK_SIGNAL_FUNC (cb_page_size_y), adjustment_y);
    gtk_signal_connect (GTK_OBJECT (adjustment_cr), "value_changed",
                        GTK_SIGNAL_FUNC (cb_page_size_cr), adjustment_cr);
    gtk_signal_connect (GTK_OBJECT (adjustment_cb), "value_changed",
                        GTK_SIGNAL_FUNC (cb_page_size_cb), adjustment_cb);

    /* Clean & Exit */
    return vbox16;
}


/* This function is called for every (audio\video) frame.
   Here the actual filtering is done. */
G_MODULE_EXPORT guint8** colourfilter_apply(guint8** src, glong size, gulong SCR, gulong PTS) {
    static glong y_xlen,p;
    static guint x,y;
    static glong xlen_ylen = width*height;
    static glong xlen_ylen54 = width*height*5/4;
    static guint8 *_src0,*_src1,*_src2;

    #ifdef DEBUG
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: colourfilter apply (Width=%i,Height=%i,PTS=%lu,SCR=%lu)",width,height,PTS,SCR);
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: colourfilter apply (src0 = %p, src1 = %p, src2 = %p)",src[0],src[1],src[2]);
    #endif

    /* Apply YCrCb adjustments */
    _src0 = src[0];
    for (y=0;y<height;y++) {
        y_xlen = y*width;
        for (x=0;x<width;x++) {
            p = x + y_xlen;
            _src0[p] = max255((guint8)(( _src0[p] * value1 ) / 100)); /* LUM plane */
        }
    }

    _src1 = src[1];
    _src2 = src[2];
    for (y=0;y<height/2;y++) {
        y_xlen = y*(width/2);
        for (x=0;x<width/2;x++) {
            p = x + y_xlen;
            _src1[p] = max255((guint8)(( _src1[p] * value3 ) / 100)); /* Cb plane */
            p = x + y_xlen;
            _src2[p] = max255((guint8)(( _src2[p] * value2 ) / 100)); /* Cr plane */
        }
    }

    /* Clean & Exit */
    return src; 
}


G_MODULE_EXPORT void colourfilter_init(gint w, gint h,
                                     gint xo, gint yo, gint xl, gint yl,
                                     gdouble fr) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: colourfilter init");
    /* Copy values */
    width = w; height = h;
    xoff = xo; yoff = yo; xlen = xl; ylen = yl;
    framerate = fr;
    /* Filter specific initialisation */
    /* Set init flag */
    init_done = TRUE;
    /* Clean & Exit */
    return;
}


/* Called when parameters need tobe reset to default, auto called when plugin used for 1st time */
G_MODULE_EXPORT void colourfilter_default(void) {                                             /* DEFINE! */
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: colourfilter default");
    /* Set value's to default */
    value1 = 100;
    value2 = 100;
    value3 = 100;
    value4 = 0;
    value5 = 0;
    /* Clean & Exit */
    return;
}


/* Called after encoding has ended. Variable can be reset etc. */
G_MODULE_EXPORT void colourfilter_destruct(void) {
    #ifdef DEBUG
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: colourfilter destruct");
    #endif
    /* Clean & Exit */
    return;
}






/* Return values of plugin (value1,value2,... value5) */
G_MODULE_EXPORT void colourfilter_values(gdouble* values) {
    values[0] = value1;
    values[1] = value2;
    values[2] = value3;
    values[3] = value4;
    values[4] = value5;
    return;
}

/* Set plugins values */
G_MODULE_EXPORT void colourfilter_values_function(gdouble *v) {
    value1 = v[0];
    value2 = v[1];
    value3 = v[2];
    value4 = v[3];
    value5 = v[4];
    return;
}

/* g_module_check_init is automatically executed upon loading */
G_MODULE_EXPORT const gchar* g_module_check_init(GModule *module) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter selftest passed");
    return NULL;
}

} //extern "C"


