/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include "clipper.hh"
#include "main.hh"
#include "fast_memcpy.hh"


gboolean clipper_init(void) {
    return TRUE;
}


/* Create a clipped copy of *src in *dest */
gboolean clipper_apply(guint8 *src[3], guint8 *dest[3],gint xoff,gint yoff,gint w, gint h,gint w_in,gint h_in) {

    register guchar *Ysrc,*Usrc,*Vsrc;
    register guchar *Ydst,*Udst,*Vdst;
    register gint y;
    register gint w2 = w/2;
    register gint w_in2 = w_in/2;
    gint h2 = h/2;
    gint xoff2 = xoff/2;

    /* Sanity checks */
    if ( (w_in<w) || (h_in<h) || ((h_in==h)&&(w_in==w)) ) {
        dest[0] = src[0];
        dest[1] = src[1];
        dest[2] = src[2];
        return FALSE;
    }
 
    /* Define plane pointers */
    Ysrc = src[0] + xoff + yoff*w_in;
    Ydst = dest[0];
    Usrc = src[1] + xoff2 + (yoff*w_in)/4;
    Udst = dest[1];
    Vsrc = src[2] + xoff2 + (yoff*w_in)/4;
    Vdst = dest[2];

    /* Clip copy Y plane */
    for (y=0;y<h;y++) {
        fast_memcpy(Ydst,Ysrc,w);
        Ydst = (guchar*)(Ydst + w);
        Ysrc = (guchar*)(Ysrc + w_in);
    }

    /* Clip copy U and V planes */
    for (y=0;y<h2;y++) {
        fast_memcpy(Udst,Usrc,w2);
        fast_memcpy(Vdst,Vsrc,w2);

        Udst = (guchar*)(Udst + w2);
        Vdst = (guchar*)(Vdst + w2);

        Usrc = (guchar*)(Usrc + w_in2);
        Vsrc = (guchar*)(Vsrc + w_in2);
    }

    return TRUE;
}

