<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: refentry.xsl,v 1.8 2003/05/24 19:16:53 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="reference">
</xsl:template>

<xsl:template match="refentry">
  <xsl:call-template name="manpage">
    <xsl:with-param name="title">
      <xsl:choose>
        <xsl:when test="./refmeta">
          <xsl:apply-templates select="./refmeta/refentrytitle" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="./refnamediv/refname[1]" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>

    <xsl:with-param name="section">
      <xsl:choose>
        <xsl:when test="./refmeta/manvolnum">
          <xsl:apply-templates select="./refmeta/manvolnum"
                               mode="header.text" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$default-manpage-section" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  
    <xsl:with-param name="h3">
      <xsl:choose>
        <xsl:when test="$header-3 = ''">
          <xsl:apply-templates 
            select="(./refentryinfo/date|./docinfo/date)[1]"
            mode="header.text" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$header-3" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
        
    <xsl:with-param name="h4">
      <xsl:choose>
        <xsl:when test="$header-4 = ''">
          <xsl:apply-templates select="./refmeta/refmiscinfo" 
                               mode="header.text" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$header-4" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
        
    <xsl:with-param name="h5">
      <xsl:choose>
        <xsl:when test="$header-5 = ''">
          <xsl:apply-templates select="ancestor::title[1]" 
                               mode="header.text" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$header-5" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>

  </xsl:call-template>
</xsl:template>

<xsl:template match="*" mode="header.text">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="refmeta">
</xsl:template>

<xsl:template match="refentrytitle">
  <b>
    <xsl:apply-templates />
  </b>
</xsl:template>

<xsl:template match="manvolnum">
  <xsl:text>(</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>)</xsl:text>
</xsl:template>

<xsl:template match="refmiscinfo">
</xsl:template>

<xsl:template match="refnamediv">
  <xsl:call-template name="SH-section">
    <xsl:with-param name="title">
      <xsl:call-template name="uppercase-title">
        <xsl:with-param name="content">
          <xsl:call-template name="gentext-title" />
        </xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>

    <xsl:with-param name="content">
      <refnameline>
        <xsl:apply-templates select="refname|refpurpose" />
      </refnameline>

      <xsl:apply-templates select="refclass" />
    </xsl:with-param>
  </xsl:call-template>

</xsl:template>

<xsl:template match="refname">
  <refname>
    <xsl:apply-templates />
  </refname>
</xsl:template>

<xsl:template match="refpurpose">
  <refpurpose>
    <xsl:apply-templates />
  </refpurpose>
</xsl:template>

<xsl:template match="refdescriptor">
</xsl:template>

<xsl:template match="refclass">
  <para>
    <xsl:if test="@role">
      <xsl:value-of select="@role"/>
      <xsl:text>: </xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </para>
</xsl:template>

<xsl:template match="refsynopsisdiv">
  <xsl:call-template name="SH-section">
    <xsl:with-param name="title">
      <xsl:choose>
        <xsl:when test="title">
          <xsl:apply-templates select="title" mode="title" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="uppercase-title">
            <xsl:with-param name="content">
              <xsl:call-template name="gentext-title" />
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refsect1">
  <xsl:call-template name="SH-section" />
</xsl:template>

<xsl:template match="refsect2">
  <xsl:call-template name="SS-section" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="refsect1/title//text()|refsect2/title//text()"
              name="uppercase-title"
              mode="title">

  <xsl:param name="content" select="." />

  <xsl:choose>
    <xsl:when test="$uppercase-headings">
      <xsl:variable name="uppercase-alphabet">
        <xsl:call-template name="gentext-text">
          <xsl:with-param name="key" select="'uppercase-alphabet'" />
        </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="lowercase-alphabet">
        <xsl:call-template name="gentext-text">
          <xsl:with-param name="key" select="'lowercase-alphabet'" />
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="translate($content, 
                                      $lowercase-alphabet,
                                      $uppercase-alphabet)" />
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$content" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
