<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: manpage.xsl,v 1.3 2003/06/15 21:39:55 stevecheng Exp $
     ********************************************************************

     &copy; 2003 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<xsl:template name="manpage">
  <xsl:param name="title" />
  <xsl:param name="section" select="$default-manpage-section" />
  <xsl:param name="h1" select="$title" />
  <xsl:param name="h2" select="$section" />
  
  <xsl:param name="h3" select="$header-3" />
  <xsl:param name="h4" select="$header-4" />
  <xsl:param name="h5" select="$header-5" />

  <xsl:param name="content">
    <xsl:apply-templates />
  </xsl:param>
  
  <manpage title="{$title}" sect="{$section}"
            h1="{$h1}" h2="{$h2}"
            h3="{$h3}" h4="{$h4}" h5="{$h5}">

    <xsl:attribute name="preprocessors">
      <xsl:if test=".//tgroup">
        <xsl:text>t</xsl:text>
      </xsl:if>
    </xsl:attribute>

    <xsl:copy-of select="$content" />
            
  </manpage>
</xsl:template>
            
</xsl:stylesheet>
