/*
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __DMXSUNLITE_H__
#define __DMXSUNLITE_H__

static int errno;
#define __KERNEL_SYSCALLS__

#include <linux/module.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/usb.h>
#include <asm/unistd.h>
#include <asm/atomic.h>

#include <dmx/dmxdev.h>


#define USB_VENDOR_DIGITALARTSYSTEM     0x0962
#define USB_PRODUCT_EZ_USB              0x1000
#define USB_PRODUCT_EZ_USB2             0x2000
#define USB_PRODUCT_EZ_USB2a            0x2001
#define USB_PRODUCT_EZ_USB3             0x3000
#define USB_PRODUCT_EZ_USB3a            0x3001

#define DMX_SLOTS          512
#define PACKET_SIZE        0x340
#define FRAMES_PER_SECOND  40

#define USBDMX_IN_BULK_BUF_SIZE 0x203


#define DRIVERNAME "dmxsunlite"

#define DMXSUNLITE_TIMEOUT (HZ) /* 1 second maximum */




/* handle up_and_exit confusion */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,9)
typedef struct semaphore            THREAD_SEM;
#define THREAD_SEM_EXIT(c,l)        up_and_exit(c,l)
#define THREAD_SEM_DECLARE(c)       DECLARE_MUTEX_LOCKED(c)
#define THREAD_SEM_INIT(c)          init_MUTEX_LOCKED(c)
#define THREAD_SEM_WAIT_COMPLETE(c) {down(c);up(c);}

#else
#include <linux/completion.h>
typedef struct completion           THREAD_SEM;
#define THREAD_SEM_EXIT(c,l)        complete_and_exit(c,l)
#define THREAD_SEM_DECLARE(c)       DECLARE_COMPLETION(c)
#define THREAD_SEM_INIT(c)          init_completion(c)
#define THREAD_SEM_WAIT_COMPLETE(c) wait_for_completion(c)
#endif

#define DEBUGLEVEL(name,level) (0)

#define USBDMX2_TIMEOUT 200

#define FUNCFRAME_(name)   name,sizeof(name)
#define _FUNCFRAME_        "= [0x%p, %u]"


#if 0
struct udmx_softc {
USBBASEDEVICE sc_dev;
  usbd_device_handle      sc_udev;      /* device */
  usbd_interface_handle   sc_iface;     /* interface */
  int                     sc_ifaceno;
  usbd_pipe_handle        sc_bulkin_pipe;
  int                     sc_bulkin;
  usbd_xfer_handle        sc_bulkin_xfer;
  usbd_pipe_handle        sc_bulkout_pipe;
  int                     sc_bulkout;
  usbd_xfer_handle        sc_bulkout_xfer;
  unsigned char           sc_bulkout_buffer[PACKET_SIZE];

  u_char                  sc_state;
#define UDMX_OPEN       0x01    /* device is open */
  int                     sc_refcnt;
  u_char                  sc_dying;

#if defined(__FreeBSD__)
  dev_t                   dev;
  dev_t                   dev_noprime;
#endif
};
#endif


struct dmxusb_interface;
struct dmxusb_universe
{
  struct dmxusb_interface *dmx_if;
  unsigned char             universe_id; /* Universe id on that interface */
  DMXUniverse              *universe;
  volatile char             data_avail;  /* for userspace: 1 = data available on universe. 0 = no new values available on universe. */
  unsigned char             buffer[512];
};



struct dmxusb_interface
{
  struct usb_device        *dmx_dev;      /* init: probe_dmx      */
  DMXInterface             *interface;
  struct dmxusb_universe   *universe;

  int                do_read;
  wait_queue_head_t  read_waitqueue;   /* wake(...) will wake up the worker thread for that interface */
  wait_queue_head_t  waitqueue;   /* wake(...) will wake up the worker thread for that interface */
  int                thread_pid;  /* pid of the worker thread */

  THREAD_SEM         thr_exited;  /* semaphore that signals that the thread is exiting */

  int                running;     /* is the worker thread running ? */
  char               data_pending;
  atomic_t           urb_submit_pending;  /* value 1 during urb submit, reset in complete function*/

  /* unsigned char bulkout_buffer[PACKET_SIZE]; */

  char bulkout_buffer[1024];
};



#define UDMX_SEND_FIRMWARE_PACKET_REQUEST 0xa0

struct udmx_firmware_packet
{
  int wValue;
  int wLength;
  u_char data[16];
};


struct sunlite_hex_record {
  __u16 address;
  __u8  data_size;
  __u8  data[16];
};


char *usberror2string (int e);

int  dmxusb_receive_bulk (struct dmxusb_interface *u2d_if, int pipe_id, char *buffer, int size);
int  dmxusb_send_bulk (struct dmxusb_interface *u2d_if, int pipe_id, char *buffer, int size);

int  udmx_read_ports (struct dmxusb_interface *usbdmx_if);

int  udmx_init_1(struct dmxusb_interface *usbdmx_if);
int  udmx_init_2(struct dmxusb_interface *usbdmx_if);
int  udmx_init_3(struct dmxusb_interface *usbdmx_if);

int  USBDMX2_startup (struct usb_device *dev, __u16 idProduct, const struct sunlite_hex_record *firmware);


int  udmx_init(struct dmxusb_interface *usbdmx_if);

void udmx_init_packet(unsigned char packet[]);
int  udmx_do_write (struct dmxusb_interface *usbdmx_if, int offs, int size, unsigned char *dmx_values);
int  udmx_update (struct dmxusb_interface *usbdmx_if);

int  udmx_in_init (struct dmxusb_interface *usbdmx_if);

void bulk_urb_complete (struct urb *purb);

#endif
