#!/usr/bin/perl

# non-GUI part of DMBT

package Debbugs::DMBT;

$bts_attrs  = [
	       'bugid',
	       'originater',
	       'date',
	       'subject',
	       'package',
	       'severity',
	       'done',
	       'mergedwith'
	      ];

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {};
  
  my ($statefile) = @_;
  
  $self->{STATEFILE} = $statefile;
  $self->{STATE} = {
		    'bugs' => [],
		   };
  $self->{BTS} = undef;

  bless ($self, $class);
  return $self;
}

sub init_ldap {
  my $self = shift;
  my ($host, $port, $dn) = @_;

  use Debbugs::RemoteBTS::LDAP;

  $self->{BTS} = new Debbugs::RemoteBTS::LDAP ($host, 
					       'port' => $port,
					       'dn' => $dn);
}

sub import_package {
  my $self = shift;
  my ($package) = @_;

  push @{$self->{STATE}->{bugs}}, $self->{BTS}->packageBugs ($package);
}

sub import_bug {
  my $self = shift;
  my ($bugid) = @_;

  push @{$self->{STATE}->{bugs}}, $self->{BTS}->bugFromID ($bugid);
}

sub bugs {
  my $self = shift;

  return @{$self->{STATE}->{bugs}};
}

sub clear_bugs {
  my $self = shift;

  $self->{STATE}->{bugs} = [];
}

use XML::Parser;

# FIXME: Loader is highly experimental stuff - mostly playing for now
sub load_xml {
  my $self = shift;

  my $parser = new XML::Parser(Style => 'Tree');
  my $tree = $parser->parsefile($self->{STATEFILE});

#   use Data::Dumper;
#   print Dumper ($tree);

  die "BugList not found" unless 'buglist' eq shift @$tree;
  $self->_load_buglist (shift @$tree);
}

sub _load_buglist {
  my $self = shift;
  my ($buglist) = @_;

  my $attr = shift @$buglist;

  while ('bug' eq shift @$buglist) {
    my $bug = new Debbugs::BugReport;
    $bug->init_from_XML_tree (shift @$buglist);
    push @{$self->{STATE}->{bugs}}, $bug;
  }

  unless ($#$buglist == -1) {
    use Data::Dumper;
    die "Other things than Bugs in BugList ($_):" . Dumper (@$buglist);
  }
}

use XML::Writer;
use IO;

sub save_xml {
  my $self = shift;

  my $output = new IO::File(">" . $self->{STATEFILE});
  my $writer = new XML::Writer(OUTPUT => $output, NEWLINES => 1);
  $writer->startTag ("buglist");
  foreach my $bug (@{$self->{STATE}->{bugs}}) {
    $bug->write_to_XML_stream ($writer);
  }
  $writer->endTag ("buglist");
  $writer->end();
  $output->close();
}

TRUE;
