#include "mp3map.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include "map.h"
#include <qapplication.h>
#include <pthread.h>
#include <sched.h>
#include <fcntl.h>

#define ALLOCATION_STEP 8192

Mp3Map::Mp3Map()
{
	framemap=NULL;
	framecount=0;
	allocation_size=0;
	bad_protection=false;
}

Mp3Map::~Mp3Map()
{
	if(allocation_size > 0)
		free(framemap);
}

Mp3Map::Mp3Map(int fd)
{
	framemap=NULL;
	framecount=0;
	allocation_size=0;
	bad_protection=false;

	attach(fd);
}

Mp3Map::Mp3Map(const char *path)
{
	framemap=NULL;
	framecount=0;
	allocation_size=0;
	bad_protection=false;

	attach(path);
}

int Mp3Map::grow(void)
{
	unsigned long *newbuf;

	if(allocation_size)
		newbuf=(unsigned long *)realloc(framemap,
				allocation_size+ALLOCATION_STEP);
	else
		newbuf=(unsigned long *)malloc(allocation_size+ALLOCATION_STEP);
	
	if(!newbuf)
		return(-1);
	allocation_size+=ALLOCATION_STEP;
	framemap=newbuf;

	return 0;
}

int Mp3Map::offset_to_frame(unsigned long offset)
{
	int i;
	
	if(!frames)
		return 0;

	for(i=frames-1;i>=0;i--)
		if(framemap[i] < offset)
			return i;
	return 0;
}

unsigned long Mp3Map::frame_to_offset(int frame)
{
	if(frame >= frames)
		return 0;
	return(framemap[frame]);
}

unsigned long Mp3Map::sample_to_offset(unsigned long sample)
{
	int frame=sample/framesize;
	return frame_to_offset(frame);
}

int Mp3Map::attach(const char *path)
{
	int fd=open(path, O_RDONLY);
	if(fd == -1)
		return -1;
	int res=attach(fd);
	close(fd);
	return res;
}

int Mp3Map::attach(int fd)
{
	char readbuf[8192];
	int bytes_in_buf=0;
	int bytes_read;
	int ofs;
	int result;
	int protection_set=0;
	struct hdr hdr;
	unsigned long frameoffset=0;

	samples=0;

	do
	{
		bytes_read=read(fd, readbuf+bytes_in_buf, 8192-bytes_in_buf);
		if(bytes_read < 0)
			break;
		bytes_in_buf+=bytes_read;

		for(ofs=0;ofs<(bytes_in_buf < 4096 ? bytes_in_buf-4 : 4096) ;ofs++)
		{
//			app->processEvents();
			if((result=DecodeHeader(readbuf+ofs, &hdr)) == 0)
			{
				if(protection_set && ofs > 0)
					if(DecodeChain(readbuf+ofs, readbuf, bytes_in_buf) < 0)
						continue;
				if(hdr.framelength > 0)
				{
					if(!protection_set && bytes_in_buf+ofs-4 > hdr.framelength)
					{
						if(DecodeHeader(readbuf+ofs+hdr.framelength, NULL) == 0)
						{
							protection_set=1;
						}
						else if(DecodeHeader(readbuf+ofs+hdr.framelength-2, NULL) == 0)
						{
							protection_set=1;
							bad_protection=true;
						}
					}
					if(bad_protection)
						hdr.framelength-=2;
					break;
				}
			}
		}
		if(result != 0)
		{
//			printf("Failed to decode frame @ %d\n", framecount);
			;
		}
		else
		{
			if(!ofs)
			{
				samples+=hdr.framesize;
				if(framemap == NULL)
				{
					bitrate=hdr.bitrate;
					samplerate=hdr.samplerate;
					framesize=hdr.framesize;
				}
				int needsize=sizeof(unsigned long)*(framecount+1);
				if(needsize > allocation_size)
					grow();
				framemap[framecount++]=frameoffset;
				ofs+=hdr.framelength;
			}
			else
			{
//				if(framecount > 0)
//					printf("Frame sync lost on frame %d, gap size %d\n", framecount, ofs);
			}
		}
		if(ofs > bytes_in_buf)
			ofs=bytes_in_buf;
		if(ofs < 0)
			break;
		memmove(readbuf, readbuf+ofs, bytes_in_buf-ofs);
		bytes_in_buf-=ofs;
		frameoffset+=ofs;
	} while(bytes_in_buf > 4);

	frames=framecount;

	seconds=samples/samplerate;

	return 0;
}

int Mp3Map::basic_info(const char *path)
{
	int fd=open(path, O_RDONLY);
	if(fd == -1)
		return -1;

	char readbuf[8192];
	int bytes_in_buf=0;
	int bytes_read;
	int ofs;
	int result;
	int protection_set=0;
	struct hdr hdr;
	unsigned long frameoffset=0;

	samples=0;

	do
	{
		bytes_read=read(fd, readbuf+bytes_in_buf, 8192-bytes_in_buf);
		if(bytes_read < 0)
			break;
		bytes_in_buf+=bytes_read;

		for(ofs=0;ofs<(bytes_in_buf < 4096 ? bytes_in_buf-4 : 4096) ;ofs++)
		{
//			app->processEvents();
			if((result=DecodeHeader(readbuf+ofs, &hdr)) == 0)
			{
				if(protection_set && ofs > 0)
					if(DecodeChain(readbuf+ofs, readbuf, bytes_in_buf) < 0)
						continue;
				if(hdr.framelength > 0)
				{
					if(!protection_set && bytes_in_buf+ofs-4 > hdr.framelength)
					{
						if(DecodeHeader(readbuf+ofs+hdr.framelength, NULL) == 0)
						{
							protection_set=1;
						}
						else if(DecodeHeader(readbuf+ofs+hdr.framelength-2, NULL) == 0)
						{
							protection_set=1;
							bad_protection=true;
						}
					}
					if(bad_protection)
						hdr.framelength-=2;
					break;
				}
			}
		}
		if(result != 0)
		{
//			printf("Failed to decode frame @ %d\n", framecount);
			;
		}
		else
		{
			if(!ofs)
			{
				samples+=hdr.framesize;
				if(framemap == NULL)
				{
					bitrate=hdr.bitrate;
					samplerate=hdr.samplerate;
					framesize=hdr.framesize;
					break;
				}
				int needsize=sizeof(unsigned long)*(framecount+1);
				if(needsize > allocation_size)
					grow();
				framemap[framecount++]=frameoffset;
				ofs+=hdr.framelength;
			}
			else
			{
//				if(framecount > 0)
//					printf("Frame sync lost on frame %d, gap size %d\n", framecount, ofs);
			}
		}
		if(ofs > bytes_in_buf)
			ofs=bytes_in_buf;
		if(ofs < 0)
			break;
		memmove(readbuf, readbuf+ofs, bytes_in_buf-ofs);
		bytes_in_buf-=ofs;
		frameoffset+=ofs;
	} while(bytes_in_buf > 4);

	frames=framecount;

	close(fd);

	struct stat st;
	if(stat(path, &st) < 0)
		return -1;
	
	if(!hdr.framelength)
		return -1;
	if(!samplerate)
		return -1;
	frames=st.st_size/hdr.framelength;
	samples=hdr.framesize*frames;

	seconds=samples/samplerate;

	return 0;
}
