#ifndef _LOADER_H_INCLUDED
#define _LOADER_H_INCLUDED

#include <qthread.h>

class StreamSource;

class Loader : public QThread
{
public:
	Loader(QString file, QWidget *dest);
	~Loader();
protected:
	void run();
	StreamSource *Source;
	QString File;
	QWidget *Dest;
};

class QLoaderEvent : public QEvent
{
public:
	enum Type {LoaderEvent = 1001};
	QLoaderEvent(StreamSource *s, QString f, Type t=LoaderEvent);
	~QLoaderEvent();

	StreamSource *source();
	QString file();
	bool error();
	void setError();
	Loader *loader();
	void setLoader(Loader *l);
protected:
	Loader *e_loader;
	QString File;
	StreamSource *Source;
	bool Error;
};

#endif
