#ifndef _JACKLOW_H_INCLUDED
#define _JACKLOW_H_INCLUDED

#include <qstring.h>
#include <jack/jack.h>
#include <qvaluelist.h>

class Client;
class Port;

class Processor
{
public:
	Processor();
	virtual ~Processor();

protected:
	virtual int process(jack_nframes_t nsamples, void *arg);
	friend class Client;
};

class Portinfo
{
public:
	jack_port_id_t id;
	QString name;
};

class Client
{
public:
	Client();
	Client(QString name, QString path=QString::null);
	~Client();

	bool init(QString name, QString path=QString::null);
	int rate();
	QString name();
	jack_client_t *client();
	void addProcessor(Processor *pl);
	void removeProcessor(Processor *pl);
	QValueList<Port *> ports;
	QValueList<Portinfo> in_ports;
	QValueList<Portinfo> out_ports;
	void checkPortConnections();
	void clearPortConnections();
protected:
	void addPort(Port *p);
	void removePort(Port *p);
	QString Name;
	int j_rate;
	QValueList<Processor *> processors;
	static int process(jack_nframes_t, void *arg);
	static void port_registration_callback(jack_port_id_t port, int, void *arg);
	jack_client_t *j_client;

	friend class Port;
};

class Port
{
public:
	enum Type {Null=0, Input=1, Output=2};
	enum Flags {None=0, Clear=1};
	Port(Client *c, QString base, int num=-1, Type t=Null, Flags f=None);
	~Port();

	jack_port_t *port;
	QString name();
	Type type();
	Client *client();
	void connect(QString to);
	void disconnect(QString to);
	void connect(Port *p);
	void *buffer(jack_nframes_t frames);
protected:
	Client *j_client;
	Type j_type;
	Flags j_flags;

	friend class Client;
};

#endif

