#ifndef __icon_entry_h
#define __icon_entry_h 1

#include <glib.h>
#include <gnome.h>

typedef struct _icon_entry icon_entry;

typedef enum _icon_entry_type icon_entry_type;

enum _icon_entry_type
{ DIRADMIN_UNDEFINED, DIRADMIN_USER, DIRADMIN_GROUP };

struct _icon_entry
{
  gchar *dn;
  gchar *name;
  icon_entry_type type;
};

void icon_entry_destroy (icon_entry * entry);

icon_entry *icon_entry_new (icon_entry * entry);

icon_entry *icon_entry_new_with_parms (gchar * name, gchar * dn,
				       icon_entry_type type);

gboolean
icon_list_click_event (GnomeIconList * widget,
		       GdkEventButton * event, gpointer user_data);

#endif
