#include <glib.h>
#include <gnome.h>
#include "appsupport.h"
#include "groups.h"

///TODAS LAS FUNCIONES RETORNAN REFERENCIAS A SUS ETRUCTURAS INTERNAS, PERO SACAN
///COPIAS DE LOS STRINGS PASADOS PARA GUARDARLOS.  ESTOS DATOS SE DESTRUYEN AL LLAMAR
///A LAS FUNCIONES DESTROY
///OTROS TIPOS DE ESTRUCTURAS COMO LISTAS, NO SE COPIAN, SOLO SE GUARDAN REFERENCIAS


void
g_debug_free (gpointer data)
{
  g_print ("\n");
  g_print ("g_debug_free: freeing element containing ");
  g_print (data);
  g_print ("\n");
  g_free (data);
}

diradmin_group *
diradmin_group_new (gchar * dn,
		    gchar * cn, gchar * gidnumber, GList * memberlist)
{

  diradmin_group *conn = NULL;

  conn = g_new (diradmin_group, 1);
  conn->diradmin_group_data = NULL;
  conn->diradmin_group_members = NULL;
  conn->diradmin_group_objectclasses = NULL;

  diradmin_group_set_attribute (conn, "dn", cn);
  diradmin_group_set_attribute (conn, "cn", cn);
  diradmin_group_set_attribute (conn, "gidnumber", gidnumber);

  diradmin_group_set_members (conn, memberlist);

  conn->diradmin_group_objectclasses =
    g_list_append (conn->diradmin_group_objectclasses, g_strdup ("top"));
  conn->diradmin_group_objectclasses =
    g_list_append (conn->diradmin_group_objectclasses,
		   g_strdup ("posixGroup"));
/*  conn->diradmin_group_objectclasses =
    g_list_append (conn->diradmin_group_objectclasses, g_strdup ("groupOfUniqueNames"));


  */

  return conn;
}

diradmin_group *
diradmin_group_duplicate (diradmin_group * tobeduped)
{

  diradmin_group *conn = NULL;

  conn = g_new (diradmin_group, 1);
  conn->diradmin_group_data = NULL;
  conn->diradmin_group_members = NULL;

  conn->diradmin_group_data =
    pairs_list_duplicate (tobeduped->diradmin_group_data);

  diradmin_group_set_members (conn, tobeduped->diradmin_group_members);


  return conn;

}


void
diradmin_group_destroy (diradmin_group * todestroy)
{
  if (todestroy)
    {
      pairs_list_destroy (todestroy->diradmin_group_data);
      diradmin_group_set_members (todestroy, NULL);
      g_free (todestroy);
    }

}


gchar *
diradmin_group_get_attribute (diradmin_group * conn, gchar * attr)
{
//  return "hola";
  g_assert (conn);
  g_assert (conn->diradmin_group_data);
  g_assert (attr);
  return pairs_list_get_attribute (conn->diradmin_group_data, attr);
}

void
diradmin_group_set_attribute (diradmin_group * conn, gchar * attr, gchar * to)
{
  g_assert (attr);
  conn->diradmin_group_data =
    pairs_list_set_attribute (conn->diradmin_group_data, attr, to);
}

void
diradmin_group_remove_attribute (diradmin_group * conn, gchar * attr)
{
  conn->diradmin_group_data =
    pairs_list_remove_attribute (conn->diradmin_group_data, attr);
}

GList *
diradmin_group_get_members (diradmin_group * conn)
{
  //return a reference to the members list.  shouldnt be manipulated outside.
  return g_list_first (conn->diradmin_group_members);
}

void
diradmin_group_add_member (diradmin_group * conn, gchar * member)
{
  diradmin_group_remove_member (conn, member);
  conn->diradmin_group_members =
    g_list_append (conn->diradmin_group_members, g_strdup (member));
  diradmin_group_add_objectclass (conn, "groupOfUniqueNames");
}

void
diradmin_group_remove_member (diradmin_group * conn, gchar * member)
{
  gchar *data;
  GList *iterator = NULL;
  iterator = g_list_first (conn->diradmin_group_members);
  while (iterator)
    {
      data = iterator->data;
      if (g_strcasecmp (member, iterator->data) == 0)
	{
	  g_free (data);
	  conn->diradmin_group_members =
	    g_list_remove (conn->diradmin_group_members, iterator->data);
	}
      iterator = g_list_next (iterator);
    }
  if (g_list_length (conn->diradmin_group_members) == 0)
    diradmin_group_remove_objectclass (conn, "groupOfUniqueNames");

}

gboolean
diradmin_group_has_member (diradmin_group * conn, gchar * allowedserver)
{
  gchar *data;
  GList *iterator = NULL;
  iterator = g_list_first (conn->diradmin_group_members);
  while (iterator)
    {
      data = iterator->data;
      if (g_strcasecmp (allowedserver, iterator->data) == 0)
	{
	  return (TRUE);
	}
      iterator = g_list_next (iterator);
    }
  return (FALSE);
}


void
diradmin_group_set_members (diradmin_group * conn, GList * memberlist)
{
  //removes all memberss in the list.  that means frees its allocated storage.

  GList *newmembers = NULL;
  GList *members = NULL;


  //free the old members list
  members = g_list_first (diradmin_group_get_members (conn));
  while (members)
    {
      g_free (members->data);
      members = g_list_next (members);
    }
  g_list_free (g_list_first (diradmin_group_get_members (conn)));

  //make a copy of the passed members list into newmembers
  members = g_list_first (memberlist);
  while (members)
    {
      newmembers = g_list_append (newmembers, g_strdup (members->data));
      members = g_list_next (members);
    }

  conn->diradmin_group_members = newmembers;
}






//objectclasses
GList *
diradmin_group_get_objectclasses (diradmin_group * conn)
{
  //return a reference to the allowedservers list.  shouldnt be manipulated outside.
  return g_list_first (conn->diradmin_group_objectclasses);
}

void
diradmin_group_add_objectclass (diradmin_group * conn, gchar * allowedserver)
{
  diradmin_group_remove_objectclass (conn, allowedserver);
  conn->diradmin_group_objectclasses =
    g_list_append (conn->diradmin_group_objectclasses,
		   g_strdup (allowedserver));
}

void
diradmin_group_remove_objectclass (diradmin_group * conn,
				   gchar * allowedserver)
{
  GList *iterator = NULL;
  iterator = g_list_find_custom (conn->diradmin_group_objectclasses,
				 allowedserver, (GCompareFunc) g_strcasecmp);
  if (iterator)
    {
      conn->diradmin_group_objectclasses =
	g_list_remove_link (conn->diradmin_group_objectclasses, iterator);
      g_free (iterator->data);
      g_list_free_1 (iterator);
    }
}


gboolean
diradmin_group_has_objectclass (diradmin_group * conn, gchar * allowedserver)
{
  gchar *data;
  GList *iterator = NULL;
  iterator = g_list_first (conn->diradmin_group_objectclasses);
  while (iterator)
    {
      data = iterator->data;
      if (g_strcasecmp (allowedserver, iterator->data) == 0)
	{
	  return (TRUE);
	}
      iterator = g_list_next (iterator);
    }
  return (FALSE);
}

void
diradmin_group_dump_objectclasses (diradmin_group * conn)
{
  gchar *data;
  GList *iterator = NULL;
  iterator = g_list_first (conn->diradmin_group_objectclasses);
  while (iterator)
    {
      data = iterator->data;
      g_print ("\nGroup object class: %s", data);
      iterator = g_list_next (iterator);
    }
}



void
diradmin_group_set_objectclasses (diradmin_group * conn, GList
				  * allowedserverlist)
{

  //removes all allowedservers in the list.  that means frees its allocated storage.

  GList *newallowedservers = NULL;
  GList *allowedservers = NULL;

  //free the old allowedservers list
  allowedservers = g_list_first (diradmin_group_get_objectclasses (conn));
  while (allowedservers)
    {
      g_free (allowedservers->data);
      allowedservers = g_list_next (allowedservers);
    }
  g_list_free (g_list_first (conn->diradmin_group_objectclasses));

  //make a copy of the passed allowedservers list into newallowedservers
  allowedservers = g_list_first (allowedserverlist);
  while (allowedservers)
    {
      newallowedservers =
	g_list_append (newallowedservers, g_strdup (allowedservers->data));
      allowedservers = g_list_next (allowedservers);
    }

  conn->diradmin_group_objectclasses = newallowedservers;
}








diradmin_group *
diradmin_group_new_from_ldap (connection_profile * usethisone, char *userdn)
{
  //conn should already be connected, or else undefined behaviour!!!

  diradmin_group *user = NULL;

  int ldap_errors;

  LDAPMessage *searchresults = NULL;
  LDAPMessage *entry = NULL;

  char **value_collection = NULL;

  gchar *filter;

  int i = 0;

  gchar *attribute;
  gchar *dn;
  BerElement *attributehandler;

  user = g_new (diradmin_group, 1);
  user->diradmin_group_data = NULL;
  user->diradmin_group_members = NULL;
  user->diradmin_group_objectclasses = NULL;


  //check 4 connection
  g_assert (connection_profile_get_ldap_handler (usethisone));

  filter = g_strconcat ("(&(objectClass=posixGroup)(cn=", userdn, "))", NULL);

  //look data up
  ldap_errors =
    ldap_search_s (connection_profile_get_ldap_handler (usethisone),
		   connection_profile_get_treeroot (usethisone),
		   LDAP_SCOPE_SUBTREE, filter, NULL, 0, &searchresults);
  if (ldap_errors)
    {

      //any error?
      g_print ("LDAP error while creating a diradmin_group structure for ");
      g_print (userdn);
      g_print (": ");
      g_print (ldap_err2string (ldap_errors));
      g_print ("\n");
    }
  else
    {
      //get only first entry
      entry =
	ldap_first_entry (connection_profile_get_ldap_handler (usethisone),
			  searchresults);

      // loop thru attribute values

      dn =
	ldap_get_dn (connection_profile_get_ldap_handler (usethisone), entry);
      diradmin_group_set_attribute (user, "dn", dn);
      g_free (dn);


      attribute =
	ldap_first_attribute (connection_profile_get_ldap_handler
			      (usethisone), entry, &attributehandler);

      g_assert (attribute);

      while (attribute)
	{
	  value_collection =
	    ldap_get_values (connection_profile_get_ldap_handler (usethisone),
			     entry, attribute);
	  g_print ("\n%s = %s\n", attribute, value_collection[0]);
	  if (g_strcasecmp (attribute, "objectClass") == 0)
	    {
	      i = 0;
	      while (value_collection[i])
		{
		  g_print ("\n adding objectclass %s\n", value_collection[i]);
		  diradmin_group_add_objectclass (user, value_collection[i]);
		  i++;
		}
	    }
	  else if (g_strcasecmp (attribute, "uniqueMember") != 0)
	    {
	      g_assert (value_collection[0]);
	      diradmin_group_set_attribute (user, attribute,
					    value_collection[0]);
	    }
	  else
	    {
	      i = 0;
	      while (value_collection[i])
		{
		  diradmin_group_add_member (user, value_collection[i]);
		  i++;
		}
	    }
	  ldap_value_free (value_collection);
	  attribute =
	    ldap_next_attribute (connection_profile_get_ldap_handler
				 (usethisone), entry, attributehandler);
	}

      ldap_msgfree (searchresults);
    }
  g_free (filter);

  return (user);
}

gchar *
gidnumber_to_cn (connection_profile * usethisone, gchar * gidnumber)
{
  //user is responsible to free the returned string

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  char **value_collection;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  gchar *toreturn = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print
	("NOT CONNECTED!!!! - returning! (while finding out gidnumber_to_cn\n");
      return (NULL);
    }

  filter = g_strconcat ("(&(objectClass=posixGroup)(gidnumber=",
			gidnumber, "))", NULL);
  attributetoreturn[0] = "cn";
  attributetoreturn[1] = NULL;
//debug:  g_print(filter);
  //look data up
  ldap_errors =
    ldap_search_s (connection_profile_get_ldap_handler
		   (usethisone),
		   connection_profile_get_treeroot (usethisone),
		   LDAP_SCOPE_SUBTREE, filter, attributetoreturn,
		   0, &results);
  if (ldap_errors)
    {

      //any error?
      g_print ("LDAP error on gidnumber_to_cn: ");
      g_print (ldap_err2string (ldap_errors));
      g_print ("\n");
      toreturn = NULL;
    }
  else
    {
      g_assert (results);
      entry =
	ldap_first_entry (connection_profile_get_ldap_handler
			  (usethisone), results); if (entry == NULL)
	{

	  //any error?
	  g_print ("\n");
	  g_print
	    ("No posix groups available for translating gid to group name");
	  g_print ("\n");
	  toreturn = NULL;
	}
      else
	{

	  value_collection =
	    ldap_get_values (connection_profile_get_ldap_handler
			     (usethisone), entry, "cn");
	  g_assert (value_collection);
	  toreturn = g_strdup (value_collection[0]);
	  ldap_value_free (value_collection);
	}

      ldap_msgfree (results);
    }
  g_free (filter);
  return (toreturn);
}

gchar *
cn_to_gidnumber (connection_profile * usethisone, gchar * cn)
{
  //user is responsible to free the returned string

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  char **value_collection;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  gchar *toreturn = NULL;
  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print
	("NOT CONNECTED!!!! - returning! (while finding out gidnumber_to_cn\n");
      return (NULL);
    }
  filter = g_strconcat ("(&(objectClass=posixGroup)(cn=", cn, "))", NULL);
  attributetoreturn[0] = "gidnumber";
  attributetoreturn[1] = NULL;
  //g_print(filter);
  //look data up
  ldap_errors =
    ldap_search_s (connection_profile_get_ldap_handler
		   (usethisone),
		   connection_profile_get_treeroot
		   (usethisone), LDAP_SCOPE_SUBTREE,
		   filter, attributetoreturn, 0, &results);
  if (ldap_errors)
    {

      //any error?
      g_print ("LDAP error on cn_to_gidnumber: ");
      g_print (ldap_err2string (ldap_errors));
      g_print ("\n");
      toreturn = NULL;
    }
  else
    {
      g_assert (results);
      entry =
	ldap_first_entry (connection_profile_get_ldap_handler
			  (usethisone), results);
      if (entry == NULL)
	{

	  //any error?
	  g_print
	    ("No posix groups available for translating gid to group name: ");
	  g_print ("\n");
	  toreturn = NULL;
	}
      else
	{

	  value_collection =
	    ldap_get_values (connection_profile_get_ldap_handler
			     (usethisone), entry, "gidnumber");
	  g_assert (value_collection);
	  toreturn = g_strdup (value_collection[0]);
	  ldap_value_free (value_collection);
	}


      ldap_msgfree (results);
    }
  g_free (filter);
  return (toreturn);
}



LDAPMod **
diradmin_group_generate_ldapdiff (diradmin_group *
				  oldone, diradmin_group * newone)
{

  LDAPMod **diffs;
  LDAPMod *curmod = NULL;
  gchar **values;
  gint curmod_counter = 0;
  gchar *attributestocheck[] = {
    NULL
  };
  GList *listone = NULL;
  gint currattribute_counter = 0;
  g_assert (oldone);
  g_assert (newone);
  diffs = g_new0 (LDAPMod *, sizeof (attributestocheck)
		  + g_list_length (diradmin_group_get_members (oldone))
		  + g_list_length (diradmin_group_get_members (newone))
//               + g_list_length(diradmin_group_get_objectclasses (oldone))
//               + g_list_length(diradmin_group_get_objectclasses (newone))
    );
  while (attributestocheck[currattribute_counter])
    {
      if (g_strcasecmp
	  (attributestocheck[currattribute_counter],
	   "groupPassword") != 0
	  && diradmin_group_get_attribute (newone,
					   attributestocheck
					   [currattribute_counter]) == NULL)
	{
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_DELETE;
	  curmod->mod_type =
	    g_strdup (attributestocheck[currattribute_counter]);
	  curmod->mod_values = NULL;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      else
	if (diradmin_group_get_attribute
	    (oldone,
	     attributestocheck[currattribute_counter]) == NULL
	    && diradmin_group_get_attribute (newone,
					     attributestocheck
					     [currattribute_counter]) != NULL)
	{
	  values = g_new0 (gchar *, 2);
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_REPLACE;
	  curmod->mod_type =
	    g_strdup (attributestocheck[currattribute_counter]);
	  values[0] =
	    g_strdup (diradmin_group_get_attribute
		      (newone, attributestocheck[currattribute_counter]));
	  values[1] = NULL;
	  curmod->mod_values = values;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      else
	if (g_strcasecmp
	    (diradmin_group_get_attribute
	     (oldone,
	      attributestocheck[currattribute_counter]),
	     diradmin_group_get_attribute (newone,
					   attributestocheck
					   [currattribute_counter])) != 0)
	{
	  values = g_new0 (gchar *, 2);
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_REPLACE;
	  curmod->mod_type =
	    g_strdup (attributestocheck[currattribute_counter]);
	  values[0] =
	    g_strdup (diradmin_group_get_attribute
		      (newone, attributestocheck[currattribute_counter]));
	  values[1] = NULL;
	  curmod->mod_values = values;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      currattribute_counter++;
    }

  g_assert (diffs);
  listone = diradmin_group_get_members (oldone);
  while (listone)
    {
      if (diradmin_group_has_member (newone, listone->data) == FALSE)
	{
	  //generar mod de eliminacion
	  values = g_new0 (gchar *, 2);
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_DELETE;
	  curmod->mod_type = g_strdup ("uniqueMember");
	  values[0] = g_strdup (listone->data);
	  values[1] = NULL;
	  curmod->mod_values = values;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      listone = g_list_next (listone);
    }
  listone = diradmin_group_get_members (newone);
  while (listone)
    {
      if (diradmin_group_has_member (oldone, listone->data) == FALSE)
	{
	  //generar mod de eliminacion
	  values = g_new0 (gchar *, 2);
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_ADD;
	  curmod->mod_type = g_strdup ("uniqueMember");
	  values[0] = g_strdup (listone->data);
	  values[1] = NULL;
	  curmod->mod_values = values;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      listone = g_list_next (listone);
    }

  listone = diradmin_group_get_objectclasses (newone);
  while (listone)
    {
      if (diradmin_group_has_objectclass (oldone, listone->data) == FALSE)
	{
	  //generar mod de adicion
	  values = g_new0 (gchar *, 2);
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_ADD;
	  curmod->mod_type = g_strdup ("objectclass");
	  values[0] = g_strdup (listone->data);
	  values[1] = NULL;
	  curmod->mod_values = values;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      listone = g_list_next (listone);
    }
  if (diradmin_group_has_objectclass (newone, "groupOfUniqueNames") == FALSE
      &&
      diradmin_group_has_objectclass (oldone, "groupOfUniqueNames") == TRUE)
    {

      //generar mod de eliminacion de este object class
      values = g_new0 (gchar *, 2);
      curmod = g_new0 (LDAPMod, 1);
      curmod->mod_op = LDAP_MOD_DELETE;
      curmod->mod_type = g_strdup ("objectClass");
      values[0] = g_strdup ("groupOfUniqueNames");
      values[1] = NULL;
      curmod->mod_values = values;
      diffs[curmod_counter] = curmod;
      curmod_counter++;

    }


  if (curmod_counter == 0)
    {
      g_free (diffs);
      diffs = NULL;
    }
  else
    diffs[curmod_counter] = NULL;

  g_print ("\nPrinting objectclasses from the old one:\n");
  diradmin_group_dump_objectclasses (oldone);
  g_print ("\nPrinting objectclasses from the new one:\n");
  diradmin_group_dump_objectclasses (newone);

  return diffs;
}

diradmin_group *
create_group_struct_from_dialogbox (connection_profile
				    * conn, GtkWidget * dialogbox, gchar * dn)
{
  //TODO: TRICK TO GET GECOS TO BE WRITTEN HERE!!!!!!

  diradmin_group *newgroup;
  gint iterator;
  gchar *cn = NULL;
  gchar *gidnumber = NULL;
  GtkCList *members = NULL;
  gchar *member = NULL;
  GList * listone;
  
  members = (GtkCList *) lookup_widget (dialogbox, "members");
  cn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (dialogbox, "cn")));
  gidnumber =
    gtk_entry_get_text (GTK_ENTRY (lookup_widget (dialogbox, "gidnumber")));
  newgroup = diradmin_group_new (dn, cn, gidnumber, NULL);
  for (iterator = 0; iterator < members->rows; iterator++)
    {
      gtk_clist_get_text (members, iterator, 0, &member);
      diradmin_group_add_member (newgroup, member);
    }

  listone = diradmin_group_get_objectclasses (newgroup);
  while (listone)
    {
     g_print(listone->data); listone=listone->next;
    }

  return (newgroup);
}



LDAPMod **
diradmin_group_create_ldapdiff (diradmin_group * newone)
{

  LDAPMod **diffs;
  LDAPMod *curmod = NULL;
  gchar **values;
  gint curmod_counter = 0;
  gchar *attributestocheck[] = {
    "cn", "gidnumber", NULL
  };
  GList *listone = NULL;
  gint currattribute_counter = 0;

  g_assert (newone);
  diffs = g_new0 (LDAPMod *, sizeof (attributestocheck)
		  + g_list_length (diradmin_group_get_members (newone))
		  +
		  g_list_length (diradmin_group_get_objectclasses (newone)));

  values = g_new0 (gchar *, 7);
  curmod = g_new0 (LDAPMod, 1);
  curmod->mod_op = LDAP_MOD_ADD;
  curmod->mod_type = g_strdup ("objectClass");
  values[0] = g_strdup ("top");
  values[1] = g_strdup ("posixGroup");
//  values[2] = g_strdup ("groupOfUniqueNames");
  values[3] = NULL;
  curmod->mod_values = values;
  diffs[curmod_counter] = curmod;
  curmod_counter++;
  while (attributestocheck[currattribute_counter])
    {
      if (diradmin_group_get_attribute
	  (newone, attributestocheck[currattribute_counter]) != NULL)
	{
	  values = g_new0 (gchar *, 2);
	  curmod = g_new0 (LDAPMod, 1);
	  curmod->mod_op = LDAP_MOD_ADD;
	  curmod->mod_type =
	    g_strdup (attributestocheck[currattribute_counter]);
	  values[0] =
	    g_strdup (diradmin_group_get_attribute
		      (newone, attributestocheck[currattribute_counter]));
	  values[1] = NULL;
	  curmod->mod_values = values;
	  diffs[curmod_counter] = curmod;
	  curmod_counter++;
	}
      currattribute_counter++;
    }

  g_assert (diffs);
  if (g_list_length(diradmin_group_get_members(newone)))
   {
    values = g_new0 (gchar *, 2);
    curmod = g_new0 (LDAPMod, 1);
    curmod->mod_op = LDAP_MOD_ADD;
    curmod->mod_type = g_strdup ("objectClass");
    values[0] = g_strdup ("groupOfUniqueNames");
    values[1] = NULL;
    curmod->mod_values = values;
    diffs[curmod_counter] = curmod;
    curmod_counter++;

    listone = diradmin_group_get_members (newone);
    while (listone)
     {
      values = g_new0 (gchar *, 2);
      curmod = g_new0 (LDAPMod, 1);
      curmod->mod_op = LDAP_MOD_ADD;
      curmod->mod_type = g_strdup ("uniqueMember");
      values[0] = g_strdup (listone->data);
      values[1] = NULL;
      curmod->mod_values = values;
      diffs[curmod_counter] = curmod;
      curmod_counter++;
      listone = g_list_next (listone);
     }
   }
  if (curmod_counter == 0)
    {
      g_free (diffs);
      diffs = NULL;
    }
  else
    diffs[curmod_counter] = NULL;
  return diffs;
}
