
sub dc_debconf_select (){
    my $class    = shift;
    my $priority = shift;
    my $question = "shared/packages-$class";
    my @newchoices = ();
    my @oldchoices = ();

    $priority = "critical" if not $priority;
    
    if ( $class eq "ispell" ){
	$title = "Dictionaries-common: Ispell dictionary"; 
    } else {
	$title = "Dictionaries-common: Wordlist dictionary"; 
    }
    
    my ($errorcode,$pkgowners) = metaget ($question, "owners");
    return if $errorcode;
    
    foreach (split (/\s*,\s*/, $pkgowners)){
	my $entry = metaget ("$_/languages", "default");
	for ( $entry ){ # trim leading/trailing whitespaces the perlfaq way
	    s/^\s+//;
	    s/\s+$//;
	}
	push (@newchoices, split(/\s*,\s*/, $entry));
    }
    my $choices = join (', ', sort {lc $a cmp lc $b} @newchoices);

    $question = "dictionaries-common/default-$class";
    @oldchoices = split(/\s*,\s*/,metaget ($question, "choices"));
    pop @oldchoices;
    my $oldchoices = join (', ', @oldchoices);
#    print STDERR "**\nnew:$choices\nold:$oldchoices\n";
    if ( $choices ne $oldchoices ) {
	subst ($question, "choices", $choices);
	fset ($question, "seen", "false");
    }

    input ($priority, $question);
    title ($title);
    go ();
}

1;

