/* $XConsortium: Main.c /main/11 1996/10/25 11:33:16 kaleb $ */
/*
 * (c) Copyright 1993,1994 by David Wexelblat <dwex@xfree86.org>
 * (c) Copyright 1994-1998 by The XFree86 Project, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 * 
 * Except as contained in this notice, the name of the copyright holders shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in this Software without prior written authorization from
 * the copyright holders.
 *
 */

/* $XFree86: xc/programs/Xserver/hw/xfree86/SuperProbe/Main.c,v 3.17.2.9 1998/10/27 05:19:53 dawes Exp $ */

#include "Probe.h"

extern void *my_malloc(size_t size);

static CONST char *SVGA_Names[NUM_VENDORS+1][CHPS_PER_VENDOR] = 
{
/* dummy */	{ "" },	
/* Ahead */	{ "Ahead|UNKNOWN|UNKNOWN",
		  "Ahead|V5000 Version A|VGA16", 
		  "Ahead|V5000 Version B|VGA16" },
/* ATI */	{ "ATI Technologies Inc|UNKNOWN|UNKNOWN", 
		  "ATI Technologies Inc|18800|VGA16", 
		  "ATI Technologies Inc|18800-1|VGA16",
		  "ATI Technologies Inc|28800-2|VGA16", 
		  "ATI Technologies Inc|28800-4|VGA16", 
		  "ATI Technologies Inc|28800-5|VGA16", 
		  "ATI Technologies Inc|28800-6|VGA16",
		  "ATI Technologies Inc|68800-3|VGA16", 
		  "ATI Technologies Inc|68800-6|VGA16", 
		  "ATI Technologies Inc|68800LX|VGA16", 
		  "ATI Technologies Inc|68800AX|VGA16",
		  "ATI Technologies Inc|88800GX-C|VGA16", 
		  "ATI Technologies Inc|88800GX-D|VGA16", 
		  "ATI Technologies Inc|88800GX-E|VGA16",
		  "ATI Technologies Inc|88800GX-F|VGA16",
		  "ATI Technologies Inc|88800CX|VGA16",
		  "ATI Technologies Inc|264CT|VGA16", 
		  "ATI Technologies Inc|264ET|VGA16",
		  "ATI Technologies Inc|264VT|VGA16", 
		  "ATI Technologies Inc|264VT-B|VGA16", 
		  "ATI Technologies Inc|264VT3|VGA16", 
		  "ATI Technologies Inc|264VT4|VGA16",
		  "ATI Technologies Inc|264GT (3D Rage I)|VGA16", 
		  "ATI Technologies Inc|264GT-B (3D Rage II)|VGA16",
		  "ATI Technologies Inc|264GT-B+DVD (3D Rage II+DVD)|VGA16",
		  "ATI Technologies Inc|264GT-IIc (3D Rage IIc)|VGA16", 
		  "ATI Technologies Inc|264GT3 (3D Rage III)|VGA16",
		  "ATI Technologies Inc|264LT|VGA16", 
		  "ATI Technologies Inc|264LT Pro|VGA16" },
/* AL */	{ "Avance Logic Inc|UNKNOWN|UNKNOWN",
		  "Avance Logic Inc|2101|SVGA", 
		  "Avance Logic Inc|2228|SVGA" },
/* CT */	{ "Chips and Technologies|UNKNOWN|UNKNOWN",
		  "Chips and Technologies|82c450|VGA16", 
		  "Chips and Technologies|82c451|VGA16", 
		  "Chips and Technologies|82c452|VGA16", 
		  "Chips and Technologies|82c453|VGA16",
		  "Chips and Technologies|82c455|VGA16", 
		  "Chips and Technologies|82c456|VGA16",
		  "Chips and Technologies|82c457|VGA16", 
		  "Chips and Technologies|F65510|VGA16",
		  "Chips and Technologies|F65520|SVGA", 
		  "Chips and Technologies|F65530|SVGA",
		  "Chips and Technologies|F65540|SVGA", 
		  "Chips and Technologies|F65545|SVGA",
		  "Chips and Technologies|F65548|SVGA", 
		  "Chips and Technologies|F65546|SVGA",
		  "Chips and Technologies|F65550|SVGA", 
		  "Chips and Technologies|F65554|SVGA",
		  "Chips and Technologies|F65555|SVGA", 
		  "Chips and Technologies|F68554|SVGA",
		  "Chips and Technologies|F69000|SVGA", 
		  "Chips and Technologies|64200 WinGine|SVGA",
		  "Chips and Technologies|F64300 WinGine|SVGA" },
/* Cirrus */	{ "Cirrus Logic|UNKNOWN|UNKNOWN",
		  "Cirrus Logic|CL-GD 510/520|VGA16", 
		  "Cirrus Logic|CL-GD 610/620|VGA16",
		  "Cirrus Logic|Video7 OEM|VGA16",
		  "Cirrus Logic|AcuMos AVGA2|VGA16",
		  "Cirrus Logic|CL-GD5402|SVGA", 
		  "Cirrus Logic|CL-GD5402 Rev 1|SVGA",
		  "Cirrus Logic|CL-GD5420|SVGA", 
		  "Cirrus Logic|CL-GD5420 Rev 1|SVGA",
		  "Cirrus Logic|CL-GD5422|SVGA", 
		  "Cirrus Logic|CL-GD5424|SVGA", 
		  "Cirrus Logic|CL-GD5426|SVGA", 
		  "Cirrus Logic|CL-GD5428|SVGA",
		  "Cirrus Logic|CL-GD5429|SVGA",
		  "Cirrus Logic|CL-GD5430/40|SVGA", 
		  "Cirrus Logic|CL-GD5434|SVGA",
		  "Cirrus Logic|CL-GD6205|SVGA", 
		  "Cirrus Logic|CL-GD6215|SVGA",
		  "Cirrus Logic|CL-GD6225|SVGA", 
		  "Cirrus Logic|CL-GD6235|SVGA",
		  "Cirrus Logic|CL-GD5410|VGA16",
		  "Cirrus Logic|CL-GD6410|SVGA", 
		  "Cirrus Logic|CL-GD6412|SVGA",
		  "Cirrus Logic|CL-GD6420A|SVGA", 
		  "Cirrus Logic|CL-GD6420B|SVGA",
		  "Cirrus Logic|CL-GD6440|SVGA",
		  "Cirrus Logic|CL-GD5436|SVGA",
		  "Cirrus Logic|CL-GD7541|SVGA", 
		  "Cirrus Logic|CL-GD7542|SVGA",
		  "Cirrus Logic|CL-GD7543|SVGA",
		  "Cirrus Logic|CL-GD5446|SVGA",
		  "Cirrus Logic|CL-GD5462|SVGA",
		  "Cirrus Logic|CL-GD7548|SVGA",
		  "Cirrus Logic|CL-GD5464|SVGA",
		  "Cirrus Logic|CL-GD5480|SVGA",
		  "Cirrus Logic|CL-GD5465|SVGA",
		},
/* Compaq */	{ "Compaq Computer Corporation|UNKNOWN|UNKNOWN",
		  "Compaq Computer Corporation|Vid. Graphics Sys.|VGA16",
		  "Compaq Computer Corporation|Advanced VGA|VGA16", 
		  "Compaq Computer Corporation|QVision/1024|VGA16", 
		  "Compaq Computer Corporation|QVision/1280|VGA16",
		  "Compaq Computer Corporation|Advanced VGA, Portable|VGA16" },
/* Genoa */	{ "Genoa|GVGA 6100|VGA16",
		  "Genoa|GVGA 6200/6300|VGA16", 
		  "Genoa|GVGA 6400/6600|VGA16" },
/* HMC */	{ "HMC|HM86304|VGA16" },
/* MX */	{ "MX|68000|VGA16", 
			"MX|68010|VGA16" },
/* NCR */	{ "NCR|UNKNOWN|UNKNOWN",
		  "NCR|77C21|VGA16", 
		  "NCR|77C22|VGA16", 
		  "NCR|77C22E|VGA16", 
		  "NCR|77C22E+|VGA16",
		  "NCR|77C32BLT|VGA16" },
/* Oak */	{ "Oak Technology, Inc|UNKNOWN|UNKNOWN",
		  "Oak Technology, Inc|OTI037C|VGA16", 
		  "Oak Technology, Inc|OTI-057|VGA16", 
		  "Oak Technology, Inc|OTI-067|SVGA", 
		  "Oak Technology, Inc|OTI-077|SVGA",
		  "Oak Technology, Inc|OTI-083|VGA16", 
		  "Oak Technology, Inc|OTI-087|SVGA" },
/* Primus */	{ "Primus|P2000|VGA16|UNKNOWN" },
/* Realtek */	{ "Realtek|UNKNOWN|UNKNOWN",
		  "Realtek|RT-3103|VGA16", 
		  "Realtek|RT-3105|VGA16", 
		  "Realtek|RT-3106|VGA16" },
/* S3 */	{ "S3 Inc.|UNKNOWN|UNKNOWN",
		  "S3 Inc.|S3 86C911|S3", 
		  "S3 Inc.|S3 86C924|S3",
		  "S3 Inc.|S3 86C801, A or B-step|S3", 
		  "S3 Inc.|S3 86C801, C-step|S3", 
		  "S3 Inc.|S3 86C801, D-step|S3", 
		  "S3 Inc.|S3 86C801i|S3",
		  "S3 Inc.|S3 86C805, A or B-step|S3", 
		  "S3 Inc.|S3 86C805, C-step|S3", 
		  "S3 Inc.|S3 86C805, D-step|S3",
		  "S3 Inc.|S3 86C805i|S3",
		  "S3 Inc.|S3 86C928, A,B,C, or D-step|S3", 
		  "S3 Inc.|S3 86C928, E-step|S3",
		  "S3 Inc.|S3 86C928PCI|S3",
		  "S3 Inc.|S3 Vision864|S3",
		  "S3 Inc.|S3 Vision964|S3",
		  "S3 Inc.|S3 Vision866|VGA16",
		  "S3 Inc.|S3 Vision868|S3",
		  "S3 Inc.|S3 Vision968|S3",
		  "S3 Inc.|S3 Trio32|S3",
		  "S3 Inc.|S3 Trio64|S3",
		  "S3 Inc.|S3 Trio64V+|S3",
		  "S3 Inc.|S3 Vision968 & 3Dlabs 300SX|VGA16",
		  "S3 Inc.|S3 Vision968 & 3Dlabs (unknown)|VGA16",
		  "S3 Inc.|S3 ViRGE|SVGA",
		  "S3 Inc.|S3 ViRGE/VX|SVGA",
		  "S3 Inc.|S3 Aurora64V+|S3",
		  "S3 Inc.|S3 Trio64UV+|S3",
		  "S3 Inc.|S3 Trio64V2/DX|S3",
		  "S3 Inc.|S3 Trio64V2/GX|S3",
		  "S3 Inc.|S3 ViRGE/DX|SVGA",
		  "S3 Inc.|S3 ViRGE/GX|SVGA",
		  "S3 Inc.|S3 PLATO/PX|VGA16",
		  "S3 Inc.|S3 ViRGE/GX2|SVGA",
		  "S3 Inc.|S3 ViRGE/MX|SVGA",
		  "S3 Inc.|S3 ViRGE/MXP|SVGA",
	       },
/* Trident */	{ "Trident Microsystems|UNKNOWN|UNKNOWN",
		  "Trident Microsystems|LX8200|VGA16",
		  "Trident Microsystems|8800BR|VGA16", 
		  "Trident Microsystems|8800CS|VGA16",
		  "Trident Microsystems|8900B|SVGA", 
		  "Trident Microsystems|8900C|SVGA", 
		  "Trident Microsystems|8900CL/8900D|SVGA",
		  "Trident Microsystems|9000|SVGA", 
		  "Trident Microsystems|9000i|SVGA",
		  "Trident Microsystems|LCD9100B", 
		  "Trident Microsystems|9200CXr|SVGA", 
		  "Trident Microsystems|LCD9320|VGA16", 
		  "Trident Microsystems|9400CXi|SVGA", 
		  "Trident Microsystems|GUI 9420|SVGA", 
		  "Trident Microsystems|GUI 9420DGi|SVGA",
                  "Trident Microsystems|GUI 9440AGi|SVGA", 
		  "Trident Microsystems|GUI 9660|SVGA", 
                  "Trident Microsystems|GUI 9680|SVGA", 
		  "Trident Microsystems|ProVidia 9682|SVGA",
		  "Trident Microsystems|ProVidia 9685|SVGA", 
		  "Trident Microsystems|ProVidia 9692|SVGA",
		  "Trident Microsystems|Cyber9382|SVGA", 
		  "Trident Microsystems|Cyber9385|SVGA",
		  "Trident Microsystems|Cyber9385-1|SVGA",
		  "Trident Microsystems|Cyber9388|SVGA", 
		  "Trident Microsystems|Cyber9388-1|SVGA",
		  "Trident Microsystems|Cyber9397|SVGA", 
		  "Trident Microsystems|Cyber9520|VGA16",
                  "Trident Microsystems|3DImage975|SVGA", 
		  "Trident Microsystems|3DImage985|SVGA", },
/* Tseng */	{ "Tseng Labs Inc|UNKNOWN|UNKNOWN",
		  "Tseng Labs Inc|ET3000|SVGA", 
		  "Tseng Labs Inc|ET4000|SVGA", 
		  "Tseng Labs Inc|ET4000/W32|W32", 
		  "Tseng Labs Inc|ET4000/W32i|SVGA", 
		  "Tseng Labs Inc|ET4000/W32p Rev A|SVGA",
		  "Tseng Labs Inc|ET4000/W32i Rev B|SVGA",
		  "Tseng Labs Inc|ET4000/W32i Rev C|SVGA",
		  "Tseng Labs Inc|ET4000/W32p Rev B|SVGA",
		  "Tseng Labs Inc|ET4000/W32p Rev C|SVGA",
		  "Tseng Labs Inc|ET4000/W32p Rev D|SVGA",
		  "Tseng Labs Inc|ET6000|SVGA", 
		  "Tseng Labs Inc|ET6100|SVGA", 
		  "Tseng Labs Inc|ET6300|VGA16"
		},
/* UMC */	{ "UMC|UMC 85c408|VGA16" },
/* Video7 */	{ "Video7|UNKNOWN|UNKNOWN",
		  "Video7|FastWrite/VRAM (HT208)|VGA16",
		  "Video7|1024i (HT208A)|VGA16",
		  "Video7|VRAM II (HT208B)|VGA16", 
		  "Video7|VRAM II (HT208C,D)|VGA16",
		  "Video7|HT216B,C|VGA16", 
		  "Video7|HT216D|VGA16",
		  "Video7|HT216E|VGA16", 
		  "Video7|HT216E|VGA16",
		  "Video7|VEGA|VGA16" },
/* WD */	{ "WD/Paradise|UNKNOWN|UNKNOWN",
		  "WD/Paradise|PVGA1|VGA16", 
		  "WD/Paradise|90C00|VGA16", 
		  "WD/Paradise|90C10|VGA16", 
		  "WD/Paradise|90C11|VGA16",
		  "WD/Paradise|90C20|VGA16", 
		  "WD/Paradise|90C20A|VGA16",
		  "WD/Paradise|90C22|VGA16", 
		  "WD/Paradise|90C24|SVGA", 
		  "WD/Paradise|90C26|VGA16", 
		  "WD/Paradise|90C27|VGA16",
		  "WD/Paradise|90C30|VGA16", 
		  "WD/Paradise|90C31|VGA16",
		  "WD/Paradise|90C33|VGA16" },
/* Weitek */	{ "Weitek|UNKNOWN|UNKNOWN)",
		  "Weitek|5086|VGA16", 
		  "Weitek|5186|VGA16", 
		  "Weitek|5286|VGA16" },
/* Yamaha */	{ "Yamaha|Yamaha 6388 VPDC|VGA16" },
/* ARK */	{ "ARK Logic|UNKNOWN|UNKNOWN",
		  "ARK Logic|ARK1000VL|SVGA",
		  "ARK Logic|ARK1000PV|SVGA",
		  "ARK Logic|ARK2000PV|SVGA",
		  "ARK Logic|ARK2000MT|SVGA",
		  "ARK Logic|ARK2000MI (Quadro64)|VGA16" },
/* Alliance */	{ "Alliance Semiconductor|UNKNOWN|UNKNOWN",
		  "Alliance Semiconductor|ProMotion 6410|VGA16",
		  "Alliance Semiconductor|ProMotion 6422|SVGA",
		  "Alliance Semiconductor|ProMotion AT24|VGA16" },
/* Epson */	{ "Epson|Epson SPC8110|SVGA" },
};

static CONST char *Herc_Names[] = 
{
	"",		/* indices start at 1 */
	"Standard",
	"Plus",
	"InColor",
};

struct RamDac_Name RamDac_Names[] =
{
	{ "Unknown", "Non-standard but unknown DAC" },
	{ "Generic", "Generic 8-bit pseudo-color DAC" },
	{ "ALG1101", "Avance Logc ALG1101" },
	{ "SS2410", "Diamond SS2410"},
	{ "Sierra15", "Sierra SC1148{1,6,8}" },
	{ "Sierra16", "Sierra SC1148{2,3,4}" },
	{ "Sierra24", "Sierra 1502{5,6}" },
	{ "MU9C4870", "MUSIC MU9C4870" },
	{ "MU9C4910", "MUSIC MU9C4910" },
	{ "ADAC1", "AcuMos ADAC1"},
	{ "68830", "ATI 68830" },
	{ "68860", "ATI 68860" },
	{ "68875", "ATI-68875/Bt885/TLC34075" },
	{ "ATIMisc", "ATI Misc 3rd-party, probably BT481" },
	{ "Cirrus8", "Cirrus Logic Built-in" },
	{ "Cirrus24B", "Cirrus Logic" },
	{ "Cirrus24", "Cirrus Logic" },
	{ "20C490", "AT&T 20C490" },
	{ "20C491", "AT&T 20C491" },
	{ "20C492", "AT&T 20C492" },
	{ "20C493", "AT&T 20C493" },
	{ "20C497", "AT&T 20C497" },
	{ "Bt485", "BrookTree Bt485" },
	{ "20C504", "AT&T 20C504" },
	{ "20C505", "AT&T 20C505" },
	{ "TVP3020", "TI 3020" },
	{ "TVP3025", "TI 3025" },
	{ "EDSUN", "EDSUN CEG DAC" },
	{ "20C498", "AT&T 20C498/21C498" },
	{ "22C498", "AT&T 22C498" },
	{ "STG1700", "STG1700" },
	{ "S3_GENDAC", "S3 GenDAC(86C708) and ICS5300" },
	{ "S3_SDAC", "S3 SDAC(86C716)" },
	{ "TVP3026", "TI ViewPoint3026" },
	{ "RGB524",  "IBM RGB524" },
	{ "RGB514/525", "IBM RGB514/525" },
	{ "RGB528", "IBM RGB528 24-bit" },
	{ "STG1703", "STG 1703" },
	{ "20C409", "AT&T 20C409" },
	{ "20C499", "AT&T 20C499" },
	{ "TKD8001", "Trident Built-In" },
	{ "TGUIDAC", "Trident Built-In" },
	{ "Integrated", "ATI Mach64 integrated" },
	{ "MU9C1880", "Music 9C1880"},
	{ "IMSG174", "Inmos G-174" },
	{ "STG1702", "STG1702" },
	{ "CH8398", "Chrontel 8398"},
	{ "20C408", "AT&T 20C408" },
	{ "TVP3030","TI ViewPoint3030" },
	{ "ET6000", "Tseng Labs ET6000 built-in" },
	{ "w30C516","IC Works w30C516 ZOOMDAC or AT&T 20C498" },
	{ "PM642x", "Alliance ProMotion" },
	{ "ICS5341", "ICS5341" },
	{ "ICS5301", "ICS5301"},
	{ "MGA1064SG", "Matrox Mystique built-in DAC w/clock" },
};



char MyName[20];
Word vgaIOBase;
Long Chip_data = (Long)~0;
Byte *Bios_Base = (Byte *)0;
Bool NoBIOS = FALSE;
Bool NoPCI = FALSE;
Bool PCIProbed = FALSE;
struct pci_config_reg *pcrp;

static Bool No16Bits = FALSE;
static Bool Exclusions = FALSE;
static Bool Mask10 = FALSE;
static Range *Excl_List = NULL;
static char *NoProbe = (char *)0;


static Chip_Descriptor *SVGA_Descriptors[] = {
    &WD_Descriptor,
    &Video7_Descriptor,
    &MX_Descriptor,
    &Genoa_Descriptor,
    &UMC_Descriptor,
    &Trident_Descriptor,
    &ATI_Descriptor,
    &Ahead_Descriptor,
    &NCR_Descriptor,
    &S3_Descriptor,
    &AL_Descriptor,
    &Cirrus54_Descriptor,
    &Cirrus64_Descriptor,
    &Epson_Descriptor,	/* is detected as Tseng (has 0x3cd as Segment too) */
    &Tseng_Descriptor,
    &RealTek_Descriptor,
    &Primus_Descriptor,
    &Yamaha_Descriptor,
    &Oak_Descriptor,
    &Cirrus_Descriptor,
    &Compaq_Descriptor,
    &HMC_Descriptor,
    &Weitek_Descriptor,
    &ARK_Descriptor,
    &Alliance_Descriptor,
    &CT_Descriptor, /* I think this is screwing people up, so put it last */
    NULL
};

static Bool TestChip __STDCARGS((Chip_Descriptor *, int *));
static Byte *FindBios __STDCARGS((void));

static Bool TestChip(chip_p, Chipset)
Chip_Descriptor *chip_p;
int *Chipset;
{
    char *p, *p1, name[64];

    if ((No16Bits) && (chip_p->bit16))
    {
    	printf("\tSkipping %s (16-bit registers)...\n", chip_p->name);
    	fflush(stdout);
    	return(FALSE);
    }
    if ((NoBIOS) && (chip_p->uses_bios))
    {
	printf("\tSkipping %s (needs BIOS read)...\n", chip_p->name);
	fflush(stdout);
	return(FALSE);
    }
    if ((Exclusions) && (Excluded(Excl_List, chip_p, Mask10)))
    {
    	printf("\tskipping %s (exclusion list)...\n", chip_p->name);
    	fflush(stdout);
    	return(FALSE);
    }
    if (NoProbe != (char *)0)
    {
	p1 = p = NoProbe;
    	while (p)
    	{
    	    p1 = strchr(p1, ',');
    	    if (p1 != NULL)
    	    {
    	    	(void)strncpy(name, p, (p1-p) > sizeof(name) ? sizeof(name) : (p1-p));
		name[sizeof(name)] = '\0';
		p1++;
    	    }
	    else
	    {
		(void)strncpy(name, p, sizeof(name) - 1);
		name[sizeof(name) - 1] = '\0';
	    }
	    if (StrCaseCmp(name, chip_p->name) == 0)
	    {
    	    	printf("\tskipping %s (noprobe list)...\n", chip_p->name);
    	    	fflush(stdout);
    		return(FALSE);
	    }
    	    p = p1;
	}
    }

    if (chip_p->f(Chipset))
    {
    	return(TRUE);
    }
    return(FALSE);
}


static Byte *FindBios()
{
    int i, score[7];
    Byte buf[3];
    Byte *base = (Byte *)0;

    for (i=0; i < 7; i++)
    {
	score[i] = 1;
    }
    for (i=0; i < 7; i++)
    {
	buf[0] = buf[1] = buf[2] = (Byte)0;
	if (ReadBIOS((unsigned)(0xC0000+(i<<15)), buf, 3) != 3)
	{
	    score[i] = 0;
	}
	else if ((buf[0] != 0x55) || (buf[1] != 0xAA) || (buf[2] < 48))
	{
	    score[i] = 0;
	}
    }
    for (i=6; i >= 0; i--)
    {
	if (score[i] != 0)
	{
	    base = (Byte *)(0xC0000+(i<<15));
	}
    }
    return(base);
}

char *probe()
{
    Byte copyright[5];
    Word Ports[10];		/* For whatever we need */
    int Primary = -1;
    int RamDac = -1;
    int MemVGA = -1;
    int i;
    Chip_Descriptor *chip_p, *matched;
    Bool NoEGA = FALSE;
    Bool PCIVGA = FALSE;
    Bool Check_CoProc;
    char *result = (char *)my_malloc(200);	
    char buf[50];

/*Initialization*/
    if (OpenVideo() < 0)
    {
	free(result);
    	fprintf(stderr, "%s: Cannot open video\n", MyName);
    	return NULL;
    }

/*BIOS base adress*/
	if (Bios_Base == (Byte *)0)
	{
	    Bios_Base = FindBios();
	    if (Bios_Base == (Byte *)0)
	    {
	    fprintf(stdout, "Could not determine BIOS base address; Assuming no EGA/VGA presents\n");
	    fflush(stdout);
	    NoEGA = TRUE;
	    }
	}

NoPCI = FALSE;

xf86scanpci();


/*VGA/EGA card detection*/
    if ((!NoBIOS) && (!NoEGA))
    {
        if (ReadBIOS(COPYRIGHT_BASE, copyright, 5) < 0)
        {
	    free(result);
    	    fprintf(stderr, "%s: Failed to read BIOS\n", MyName);
    	    CloseVideo();
    	    return NULL;
        }
    }
    if (PCIVGA ||
       ((!NoEGA) &&
	((NoBIOS) ||
         ((copyright[0] == 'I') && 
          (copyright[1] == 'B') &&
          (copyright[2] == 'M')) ||
         ((copyright[2] == 'P') && 
          (copyright[3] == 'C') &&
          (copyright[4] == 'I')))))
    {
    	Ports[0] = 0x3CC;
    	EnableIOPorts(1, Ports);
    	vgaIOBase = (inp(0x3CC) & 0x01) ? 0x3D0 : 0x3B0;
	DisableIOPorts(1, Ports);
    
    	if (!Probe_VGA(&Primary))
    	    Primary = CHIP_EGA;
    

/*SVGA card detection*/
	matched = &VGA_Descriptor;

	    for (i=0; SVGA_Descriptors[i] != NULL; i++)
	    {
		chip_p = SVGA_Descriptors[i];
		if (TestChip(chip_p, &Primary))
		{
		    matched = chip_p;
		    break;
		}
	    }

/*VGA Coprocessor detection & memory probing ability*/
Check_CoProc = matched->check_coproc;

	    if (matched->memcheck != (MemCheckFunc)NULL)
	    {
		MemVGA = (*matched->memcheck)(Primary);
	    }
	    else
	    {
		printf("Memory probe not supported for this chipset.\n");
		fflush(stdout);
	    }

    }
    else if (Probe_MDA(&Primary))
    {
    	(void)Probe_Herc(&Primary);
    }


/*Process the chipset data(Primary)*/
    putchar('\n');
    if (Primary == -1)
    {
	free(result);
    	fprintf(stderr, "Could not identify any video\n");
	return NULL;
    }
    else 
    {
    	if (IS_MDA(Primary))
    	{
	    free(result);
    	    fprintf(stdout, "MDA\n");
	    return NULL;	
    	}
    	else if (IS_HERC(Primary))
    	{
	    free(result);
    	    fprintf(stdout, "Hercules\n");
	    fprintf(stdout, "\tChipset: %s\n", Herc_Names[HERC_CHIP(Primary)]);
	    return NULL;	
    	}
    	else if (IS_CGA(Primary))
    	{
	    free(result);
    	    fprintf(stdout, "CGA\n");
	    return NULL;	
    	}
    	else if (IS_MCGA(Primary))
    	{
	    free(result);
    	    fprintf(stdout, "MCGA\n");
	    return NULL;
    	}
    	else if (IS_EGA(Primary))
    	{
	    free(result);
    	    fprintf(stdout, "EGA\n");
	    return NULL;
    	}
    	else if (IS_VGA(Primary))
    	{
	    free(result);
    	    fprintf(stdout, "Generic VGA (or unknown SVGA)\n");
	    return "NONE|Generic VGA|VGA16|256|NONE"; 	
    	}
    	else if (IS_SVGA(Primary))
    	{
	    strcpy(result, SVGA_Names[SVGA_VENDOR(Primary)][SVGA_CHIP(Primary)]);

	    if (MemVGA > -1)
	    {
	       if (MemVGA >> 16)
	       {
		  sprintf(buf, "|%d|", MemVGA & 0xffff);
		  strcat(result, buf);
	       }
	       else 
		  sprintf(buf, "|%d|", MemVGA);
		  strcat(result, buf);
	    } else
	    	strcat(result, "|0|");

		/*RamDAC probing*/
		Probe_RamDac(Primary, &RamDac);
		strcat(result, RamDac_Names[DAC_CHIP(RamDac)].Long);
    	}
}
    CloseVideo();
    return result;
}
