/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 * 
 *  Copyright (C) 2001  Gergely Nagy <algernon@debian.org>
 *  Copyright (C) 2002,2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */

#ifndef DEC_PROM_H
#define DEC_PROM_H

#define DEC_REX_MAGIC 		0x30464354

#define DEC_CPUNUM(sysid) ((sysid >> 24) & 0xff)
#define DEC_SYSTYPE(sysid) ((sysid >> 16) & 0xff)
#define DEC_FIRMREV(sysid) ((sysid >> 8) & 0xff)
#define DEC_ETC(sysid) (sysid & 0xff)

#define SYS_DSUNKNOWN		0
#define SYS_DS23100		1	/* DECstation 2100 or 3100 */
#define SYS_DS5000_200		2	/* DECstation 5000/200 */
#define SYS_DS5000_1XX		3	/* DECstation 5000/120, 125, 133, 150 */
#define SYS_DS5000_2X0		4	/* DECstation 5000/240, 260 */
#define SYS_DS5800		5	/* DECstation 5800 */
#define SYS_DS5400		6	/* DECstation 5400 */
#define SYS_DS5000_XX		7	/* DECstation 5000/20, 25, 33, 50 */
#define SYS_DS5500		11	/* DECstation 5500 */
#define SYS_DS5100		12	/* DECstation 5100 */

#define FIRM_TFC0		2
#define FIRM_TFC1		3

/* Function offsets */
#define REX_PROM_STRCAT			0x08
#define REX_PROM_STRCMP			0x0c
#define REX_PROM_STRCPY			0x10
#define REX_PROM_STRLEN			0x14
#define REX_PROM_GETCHAR		0x24

#define REX_PROM_GETS			0x28
#define REX_PROM_PUTS			0x2c
#define REX_PROM_PRINTF			0x30

#define REX_PROM_BOOTINIT       	0x54
#define REX_PROM_BOOTREAD       	0x58

#define REX_PROM_GETENV			0x64
#define REX_PROM_SLOTADDR		0x6c

#define REX_PROM_CLEARCACHE		0x7c
#define REX_PROM_GETSYSID		0x80

#define REX_PROM_GETBITMAP		0x84

#define REX_PROM_HALT			0x9C

#define REX_PROM_GETTCINFO		0xa4

/* The size of each function */
#define PROM_FSIZE		4

#ifndef __ASSEMBLY__

extern int dec_sysid;

/* Some broken firmware (5000/120, KN02-BA V5.7e) returns -1 for bootinit. */
#define BROKEN_BOOTINIT(sysid) ((DEC_SYSTYPE(sysid) == SYS_DS5000_1XX) \
				&& (DEC_FIRMREV(sysid) == FIRM_TFC0))

#define BROKEN_BOOTREAD(sysid) ((DEC_SYSTYPE(sysid) == SYS_DS5000_1XX) \
				&& (DEC_FIRMREV(sysid) == FIRM_TFC0))

struct callback {
	void *unused1[11];		 /* unused functions 0x0 - 0x28 */
	int (*_puts)(char *s);					/* 0x2c */
	int (*_printf)(char *fmt, ...);				/* 0x30 */	
	void *unused2[8];		/* unused functions 0x34 - 0x50 */
	int (*_bootinit)(char *fname);				/* 0x54 */
	int (*_bootread)(int b, void *buffer, int n);		/* 0x58 */
	void *unused3[8];		/* unused functions 0x5c - 0x78 */
	int (*_clearcache)(void);				/* 0x7c */
	int (*_getsysid)(void);					/* 0x80 */
	void *unused4[6];		/* unused functions 0x84 - 0x98 */
	void (*_halt)(int a, int b);				/* 0x9c */
};

extern const struct callback *callv;

/* MIPS CPUs have their reset vector at 0xbfc00000 */
#define EMERGENCY_RESET (((void (*)(void))0xbfc00000))

#endif /* !__ASSEMBLY__ */

#endif /* !DEC_PROM_H */
