/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License, Version 2.  See the file "COPYING" in the main directory of this
 * archive for more details.
 *
 * Some ECOFF definitions, from linux/arch/mips/boot/ecoff.h
 */
struct filehdr {
	unsigned short f_magic;        /* magic number */
#define MIPSEBMAGIC	0x160
#define MIPSELMAGIC	0x162
	unsigned short f_nscns;        /* number of sections */
	int f_timdat;                  /* time & date stamp */
	int f_symptr;                  /* file pointer to symbolic header */
	int f_nsyms;                   /* sizeof(symbolic hdr) */
	unsigned short f_opthdr;       /* sizeof(optional hdr) */
	unsigned short f_flags;        /* flags */
} __attribute__((packed));

struct aouthdr {
	short magic;        /* magic number */
#define OMAGIC		0407
#define NMAGIC		0410
#define ZMAGIC		0413
#define SMAGIC		0411
#define LIBMAGIC        0443
	short vstamp;       /* version stamp */
	int tsize;          /* text size in bytes, padded to DW bdry*/
	int dsize;          /* initialized data, padded to DW bdry  */
	int bsize;          /* uninitialized data, padded to DW bdry*/
	int entry;          /* entry pt. */
	int text_start;     /* base of text used for this file */
	int data_start;     /* base of data used for this file */
	int bss_start;      /* base of bss used for this file */
	int gprmask;        /* general purpose register mask */
	int cprmask[4];     /* co-processor register masks */
	int gp_value;       /* the gp value used for this object */
} __attribute__((packed));

struct scnhdr {
	char s_name[8];     /* section name */
	int s_paddr;        /* physical address, aliased s_nlib */
	int s_vaddr;        /* virtual address */
	int s_size;         /* section size */
	int s_scnptr;       /* file ptr to raw data for section */
	int s_relptr;       /* file ptr to relocation */
	int s_lnnoptr;      /* file ptr to gp histogram */
	unsigned short s_nreloc;       /* number of relocation entries */
	unsigned short s_nlnno;        /* number of gp histogram entries */
	int s_flags;        /* flags */
} __attribute__((packed));

struct ecoff_file_start {
	struct filehdr efh;
	struct aouthdr eah;
	struct scnhdr esecs[6];
	unsigned int _pad;
} __attribute__((packed));

#define N_TXTOFF(f, a)							\
  (((a).magic == ZMAGIC || (a).magic == LIBMAGIC)			\
   ? 0									\
   : (((a).vstamp < 23)							\
       ? ((sizeof(struct filehdr) + sizeof(struct aouthdr)		\
	   + (f).f_nscns * sizeof(struct scnhdr) + 7) & ~7)		\
       : ((sizeof(struct filehdr) + sizeof(struct aouthdr)		\
	   + (f).f_nscns * sizeof(struct scnhdr) + 15) & ~15)))

#define N_DATOFF(f, a)							\
  N_TXTOFF(f, a) + (a).tsize

#define N_BSSOFF(f, a)							\
  N_DATOFF(f, a) + (((a).dsize + 15) & ~15)
