
#include "delo.h"

#define _SECTOR_SIZE 512
#define MSDOS_LABEL_MAGIC 0xAA55

#define DOS_EXTENDED_PARTITION 5
#define LINUX_EXTENDED_PARTITION 0x85
#define WIN98_EXTENDED_PARTITION 0x0f
#define LINUX_NATIVE 0x83

extern void *malloc(int);
struct partition {
	unsigned char boot_ind;		/* 0x80 - active */
	unsigned char head;		/* starting head */
	unsigned char sector;		/* starting sector */
	unsigned char cyl;		/* starting cylinder */
	unsigned char sys_ind;		/* What partition type */
	unsigned char end_head;		/* end head */
	unsigned char end_sector;	/* end sector */
	unsigned char end_cyl;		/* end cylinder */
	unsigned int start_sect;	/* starting sector counting from 0 */
	unsigned int nr_sects;		/* nr of sectors in partition */
};

unsigned int getpartoffset(char *partition) {
	int				fd, i, k,
					pno=0,
					j,estart,pstart,retval;
	unsigned char			*fb=malloc(512) + 8; /* Unaligned */
	struct partition		*p=0,
					*ep=0;

	/* Convert partition number (ascii) to int
	 * This might be empty - pno will be 0 and we
	 * will take the first ext2/linux partition */
	for(i=0;partition[i]!=0x0;i++)
		pno=pno*10 + partition[i] - '0';

#ifdef DEBUG
	printf("Partition '%s' %d\n",partition, pno);
#endif

	/* Read first sector */
	retval=bootread(0,fb,1 * _SECTOR_SIZE);

	/* Copy 2 bytes to back - Unaligned stuff :( */
	for(k=_SECTOR_SIZE;k>=0;--k)
		fb[k+2]=fb[k];
#ifdef DEBUG
	printf("bootread returned %d\n",retval);
#endif
	if (*(unsigned short *) (fb + 0x1fe + 2) != MSDOS_LABEL_MAGIC) {
		puts("No DOS disklabel found");
		return 0;
	}

#ifdef DEBUG
	puts("DOS disklabel found");
#endif

	p = (struct partition *) ( fb + 0x1be + 2 );

	for(i=1;i<=4;i++) {

#ifdef DEBUG
		printf("%2d %2x %2x %8d %8d\n", i, p->boot_ind, p->sys_ind,
				p->start_sect, p->nr_sects);
#endif

		/* Ignore empty partitions */
		if (!p->nr_sects)
			continue;

		/* Ignore extended now */
		if (p->sys_ind == DOS_EXTENDED_PARTITION ||
			p->sys_ind == LINUX_EXTENDED_PARTITION ||
			p->sys_ind == WIN98_EXTENDED_PARTITION) {

			/* Store extended partition pointer for later */
			ep=p;
			estart=pstart=p->start_sect;
			continue;
		}

		/* If we found the partition pno or we 
		 * want the first native partition */
		if (i == pno || p->sys_ind == LINUX_NATIVE && pno == 0)
			return(p->start_sect);

		p++;
	}
	while(ep != 0) {

		/* Read extended partition start */
		bootread(pstart, fb, 1 * _SECTOR_SIZE);

		/* Copy 2 bytes to back - Unaligned stuff :( */
		for(k=_SECTOR_SIZE;k>=0;--k)
			fb[k+2]=fb[k];

		/* If this doesnt contain a LABEL_MAGIC we havent got
		 * any further partition tables */
		if (*(unsigned short *) (fb + 0x1fe + 2) != MSDOS_LABEL_MAGIC) {
			printf("Magic failed\n");
			break;
		}

		ep=0;
		p=(struct partition *) ( fb + 0x1be + 2 );

		for(j=1;j<=4;j++,p++) {
			if (!p->nr_sects)
				continue;

			if (p->sys_ind == DOS_EXTENDED_PARTITION ||
				p->sys_ind == LINUX_EXTENDED_PARTITION ||
				p->sys_ind == WIN98_EXTENDED_PARTITION) {

				pstart=estart + p->start_sect;

				ep=p;
				continue;
			}
#ifdef DEBUG
			printf("%2d %2x %2x %8d %8d\n", i, p->boot_ind,
					p->sys_ind,
					p->start_sect, p->nr_sects);
#endif

			/* if we got pno or we want the first linux native */
			if (pno == i || p->sys_ind == LINUX_NATIVE && pno == 0) 
				return(estart + p->start_sect);

			i++;
		}
	}
	return(0);	
}


