#ifndef xcontrol_dependency_list_h_
#define xcontrol_dependency_list_h_ 1

#include "dependency.h"

#include <string>
#include <list>
#include <ostream>

#include <iostream>

class dependency_list :
	public std::list<dependency>
{
public:
	dependency_list &operator=(std::string const &);
	operator std::string(void) const;

	dependency_list &operator+=(dependency_list const &rhs);

};

inline std::ostream &operator<<(std::ostream &stream, dependency_list const &list)
{
	std::ostream::sentry sentry(stream);
	if(!sentry)
		return stream;

	stream << std::string(list);
	return stream;
}

#endif
