#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstdlib>

#include "architecture.h"

#include "command.h"
#include "pipe.h"

#include <ext/stdio_filebuf.h>

architecture::architecture(std::string const &name) : std::string(name) { }

architecture const architecture::build(get_build_arch());
architecture const architecture::host(get_host_arch());

architecture architecture::get_build_arch(void)
{
	class pipe result;
	command::arg_list args;
	args.push_back("dpkg");
	args.push_back("--print-architecture");
	command::env_list env;
	command dpkg_cmd("/usr/bin/dpkg", args, env, shared_fd::devnull, result.input, shared_fd::devnull);
	dpkg_cmd.run();
	__gnu_cxx::stdio_filebuf<char> resbuf(result.output, std::ios::in);
	std::istream res(&resbuf);
	std::string arch;
	res >> arch;
	dpkg_cmd.wait();

	return architecture(arch);
}

architecture architecture::get_host_arch(void)
{
	char const *env_hostarch = ::getenv("DEB_HOST_ARCH");
	if(!env_hostarch)
		return build;
	return architecture(env_hostarch);
}
