/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * packet_define.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: packet_define.h,v 1.2 2003/05/31 13:50:14 ericprev Exp $
*/

#ifndef __PACKET_DEFINE_H__
#define __PACKET_DEFINE_H__

/* list of all known ed2k opcode for client<->server dialog*/
typedef enum
{
	CS_HELLO_ID=0x01,
	CS_BAD_PROTO=0x05,
	CS_GET_SERVER_LIST=0x14,
	CS_OFFER_FILES=0x15,
	CS_SEARCH_FILE=0x16,
	CS_DISCONNECT=0x18,
	CS_GET_SOURCES=0x19,
	CS_SEARCH_USER=0x1A,
	CS_UNDEFINED1=0x1B,		/* ? */
	CS_CLIENT_CB_REQUEST=0x1C,
	CS_UNDEFINED2=0x20,
	CS_MORE_RESULTS=0x21,
	CS_SERVER_LIST=0x32,
	CS_SEARCH_FILE_RESULTS=0x33,
	CS_SERVER_STATUS=0x34,
	CS_SERVER_CB_REQUEST=0x35,
	CS_CALLBACK_FAIL=0x36,
	CS_SERVER_MESSAGE=0x38,
	CS_ID_CHANGE=0x40,
	CS_SERVER_INFO_DATA=0x41,
	CS_FOUND_SOURCES=0x42,
	CS_SEARCH_USER_RESULTS=0x43
} CS_OP_ID;

typedef struct
{
	guint32 ip;
	guint16 port;
} DEF_IP_PORT;

#endif
