/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hublist.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* 1/3/2002 - Thomas@Stewarts.org.uk - added web proxy suport */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>
#include <string.h>
#include <glib.h>

char hostname[] = "www.neo-modus.com";
int hostport = 80;
char query[] =	"GET /PublicHubList.config HTTP/1.1\n"					\
		"Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\n"	\
		"Host: www.neo-modus.com\n"						\
		"Cache-Control: no-cache\n"						\
		"Connection: close\n"							\
		"\n";

char proxyquery[] = "GET http://www.neo-modus.com/PublicHubList.config HTTP/1.1\n"	\
		"Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\n"	\
		"Host: www.neo-modus.com\n"						\
		"Cache-Control: no-cache\n"						\
		"Connection: close\n"							\
		"\n";

#define TAILLE 4096

#define DIRECT 1
#define SOCKS 2
#define PROXY 3

/****************************************************************************************/
/* perform the socket connection. Connection is based on value of connect_type.         */
/* If = DIRECT then direct connect is used, if = SOCKS then socks is used, if = DIRECT  */
/* then web proxy is used. And yes I know passing flags is ugly!                        */
/****************************************************************************************/
static int do_connect(int desc,struct sockaddr_in nom,char *socks_ip,char *socks_port, char *socks_name, int connect_type)
{
	int ret=-1;
	GByteArray *cmd=NULL;
	struct sockaddr_in socks_cnx;
	struct hostent *socks_host;
	unsigned char val[9];

	
	switch(connect_type) {
	case DIRECT:
	case PROXY:
		ret=connect(desc,(void*)&nom,sizeof(nom));
	break;

	case SOCKS:
		if((socks_host=gethostbyname(socks_ip))==NULL)
			goto eofunc;
		memcpy(&socks_cnx.sin_addr,socks_host->h_addr,socks_host->h_length);
		socks_cnx.sin_family=AF_INET;
		socks_cnx.sin_port=htons(strtoul(socks_port,NULL,10));

		ret=connect(desc,(void*)&socks_cnx,sizeof(socks_cnx));
		if(ret==-1)
		{
			perror("socks connect");
			goto eofunc;
		}

		cmd=g_byte_array_new();
		val[0]=4;		/* socks version 4 */
		val[1]=1;		/* CONNECT */
		val[2]=ntohs(nom.sin_port)>>8;
		val[3]=ntohs(nom.sin_port)&255;
		val[4]=ntohl(nom.sin_addr.s_addr)>>24;
		val[5]=ntohl(nom.sin_addr.s_addr)>>16;
		val[6]=ntohl(nom.sin_addr.s_addr)>>8;
		val[7]=ntohl(nom.sin_addr.s_addr);
		cmd=g_byte_array_append(cmd,val,8);
		if(socks_name!=NULL)
		{
			cmd=g_byte_array_append(cmd,socks_name,strlen(socks_name));
		}
		val[0]='\0';
		cmd=g_byte_array_append(cmd,val,1);

		if(send(desc,cmd->data,cmd->len,MSG_NOSIGNAL|MSG_DONTWAIT)!=cmd->len)
		{
			perror("socks send CONNECT");
			ret=-1;
			goto eofunc;
		}

		if(recv(desc,val,8,MSG_WAITALL|MSG_NOSIGNAL)!=8)
		{
			perror("socks receive CONNECT result");
			ret=-1;
			goto eofunc;
		}

		if(val[0]!=0)		/*  reply code version 0 ? */
		{
			fprintf(stderr,"socks CONNECT result: unknown reply code version (%d)",(int)(val[0]));
			ret=-1;
			goto eofunc;
		}

#if 0
		printf("%X\n",val[1]);
#endif
		if(val[1]!=90)
		{
			fprintf(stderr,"socks CONNECT result: access denied or failed (%d)",(int)(val[1]));
			ret=-1;
			goto eofunc;
		}
		ret=0;
#if 0
		printf("SOCKS connected\n");
#endif
	eofunc:
	if(cmd!=NULL)
		g_byte_array_free(cmd,TRUE);
	break;
	
	default:
	break;
	}

	return ret;
}
int main(int argc,char **argv)
{
	struct sockaddr_in nom;	/* adresse de la socket destinataire */
	int desc;		/* descripteur de la socket cree */
	struct hostent *hp;

	char com[TAILLE];
	FILE *output;
	int i;
	long nb;
	char *socks_ip=NULL;
	char *socks_port=NULL;
	char *user_id=NULL;
	char *proxy_host=NULL;
	char *proxy_port=NULL;
	int connect_type=DIRECT;

#if 0
	for(i=0;i<argc;i++)
		printf("%d, %s\n", i, argv[i]);
#endif

	if(argc!=1)
	{
		if((argc!=4)&&(argc!=5))
		{
			printf("Usage: %s --socks SocksProxyAddress SocksProxyPort [userID]\n",argv[0]);
			printf("          --proxy ProxyHost ProxyPort\n");
			exit(0);
		}

		if(strstr(argv[1], "socks") != NULL) {
			socks_ip=argv[2];
			socks_port=argv[3];
			if(argc == 5)
				user_id=argv[4];
			connect_type=SOCKS;
#if 0
			printf("Using socks: '%s' port: '%s' (id: '%s')\n",socks_ip,socks_port, user_id!=NULL?user_id:"");
#endif
		}		
		
		if(strstr(argv[1], "proxy") != NULL) {
			proxy_host=argv[2];
			proxy_port=argv[3];
			connect_type=PROXY;
#if 0
			printf("Using proxy: '%s' port: '%s'\n",proxy_host,proxy_port);
#endif
		}
	}

	output=stdout;

	/* cration de la socket */
	if((desc=socket(AF_INET,SOCK_STREAM,0))==-1)
	{
		perror("unable to create socket");
		exit(1);
	}

	/* recherche de l'adresse internet du serveur */
	if(connect_type==PROXY)
		hp=gethostbyname(proxy_host);
	else
		hp=gethostbyname(hostname);

	if(hp==NULL)
	{
		fprintf(stderr,"Unable to find host address.\n");
		exit(1);
	}

	/* demande de connexion */
	for(i=0;i<3;i++)
	{
		int ret;

		/* prparation de l'adresse de la socket destinataire */
		memcpy(&nom.sin_addr,hp->h_addr,hp->h_length);
		nom.sin_family=AF_INET;
		nom.sin_port=htons(hostport);
		if(connect_type==PROXY)
			nom.sin_port=htons(atoi(proxy_port));

		ret=do_connect(desc,nom,socks_ip,socks_port,user_id,connect_type);
		if(ret!=-1)
		{
			int eoh;
			int have;
			/* send the query */
			if(connect_type==PROXY)
				send(desc,proxyquery,strlen(proxyquery),0);
			else
				send(desc,query,strlen(query),0);

			/* reception du bloc reponse */
			
			/* skip html header */
			eoh=0;
			have=0;
			do
			{
				if((recv(desc,com,1,MSG_WAITALL))<=0)
					exit(0);

				if(com[0]=='\n')
				{
					if(have==0)
						have=1;
					else
						eoh=1;		/* 2 consecutives \n */
				}
				else if(com[0]!='\r')
					have=0;

#if 0
				printf("=%c",com[0]);
#endif
			} while(eoh==0);

			/* display body content */
			do
			{
				nb=recv(desc,com,TAILLE,0);
				if(nb>0)
				{
					fwrite(com,nb,1,output);
				}
				fflush(stderr);
			}while(nb>0);

			exit(0);
		}
	}
	perror("connect");
	exit(0);
}

