/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.IX
{
	/// <summary>An addition to a field index.</summary>
	/// <remarks>An addition to a field index.</remarks>
	public class IxAdd : Db4objects.Db4o.Internal.IX.IxPatch
	{
		internal bool _keepRemoved;

		public IxAdd(Db4objects.Db4o.Internal.IX.IndexTransaction a_ft, int a_parentID, object
			 a_value) : base(a_ft, a_parentID, a_value)
		{
		}

		internal override void BeginMerge()
		{
			base.BeginMerge();
			Handler().PrepareComparison(Handler().ComparableObject(Trans(), _value));
		}

		public override void Visit(object obj)
		{
			((Db4objects.Db4o.Foundation.IVisitor4)obj).Visit(_parentID);
		}

		public override void Visit(Db4objects.Db4o.Foundation.IVisitor4 visitor, int[] lowerAndUpperMatch
			)
		{
			visitor.Visit(_parentID);
		}

		public override void FreespaceVisit(Db4objects.Db4o.Internal.Freespace.FreespaceVisitor
			 visitor, int index)
		{
			visitor.Visit(_parentID, ((int)_value));
		}

		public override int Write(Db4objects.Db4o.Internal.IX.IIndexable4 a_handler, Db4objects.Db4o.Internal.StatefulBuffer
			 a_writer)
		{
			a_handler.WriteIndexEntry(a_writer, _value);
			a_writer.WriteInt(_parentID);
			a_writer.WriteForward();
			return 1;
		}

		public override string ToString()
		{
			return base.ToString();
			string str = "IxAdd " + _parentID + "\n " + Handler().ComparableObject(Trans(), _value
				);
			return str;
		}

		public override void VisitAll(Db4objects.Db4o.Foundation.IIntObjectVisitor visitor
			)
		{
			visitor.Visit(_parentID, Handler().ComparableObject(Trans(), _value));
		}

		public override object ShallowClone()
		{
			Db4objects.Db4o.Internal.IX.IxAdd add = new Db4objects.Db4o.Internal.IX.IxAdd(_fieldTransaction
				, _parentID, _value);
			base.ShallowCloneInternal(add);
			add._keepRemoved = _keepRemoved;
			return add;
		}
	}
}
