/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Querying
{
	public class CascadeOnDelete : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Item
		{
			public string item;
		}

		public Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item[] items;

		public virtual void Test()
		{
			NoAccidentalDeletes();
		}

		private void NoAccidentalDeletes()
		{
			NoAccidentalDeletes1(true, true);
			NoAccidentalDeletes1(true, false);
			NoAccidentalDeletes1(false, true);
			NoAccidentalDeletes1(false, false);
		}

		private void NoAccidentalDeletes1(bool cascadeOnUpdate, bool cascadeOnDelete)
		{
			DeleteAll(GetType());
			DeleteAll(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item));
			Db4objects.Db4o.Config.IObjectClass oc = Db4objects.Db4o.Db4oFactory.Configure().
				ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete));
			oc.CascadeOnDelete(cascadeOnDelete);
			oc.CascadeOnUpdate(cascadeOnUpdate);
			Reopen();
			Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item i = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item
				();
			Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete cod = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete
				();
			cod.items = new Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item[] { i };
			Db().Set(cod);
			Db().Commit();
			cod.items[0].item = "abrakadabra";
			Db().Set(cod);
			if (!cascadeOnDelete && !cascadeOnUpdate)
			{
				Db().Set(cod.items[0]);
			}
			Db4oUnit.Assert.AreEqual(1, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item)
				));
			Db().Commit();
			Db4oUnit.Assert.AreEqual(1, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeOnDelete.Item)
				));
		}
	}
}
