dnl
dnl davfs2 macros
dnl


AC_DEFUN([DAV_CHECK_NEON],[

    AC_ARG_WITH(neon,
      [  --with-neon[[=DIR]]       specify location of neon library],
      [case $withval in
          yes|no) neon_ext_path= ;;
          *) neon_ext_path=$withval ;;
      esac;],
      [neon_ext_path=]
    )

    neon_got_library=no
    if test "x$neon_ext_path" = "x"; then
        AC_PATH_PROG([NEON_CONFIG], neon-config, none)
        if test "x${NEON_CONFIG}" = "xnone"; then
            AC_MSG_NOTICE([no external neon library found])
        elif test -x "${NEON_CONFIG}"; then
            NEON_USE_EXTERNAL
        else
            AC_MSG_NOTICE([ignoring non-executable ${NEON_CONFIG}])
        fi
    else
        AC_MSG_CHECKING([for neon library in $neon_ext_path])
        NEON_CONFIG="$neon_ext_path/bin/neon-config"
        if test -x ${NEON_CONFIG}; then
            AC_MSG_RESULT([found])
            NEON_USE_EXTERNAL
        else
            AC_MSG_RESULT([not found])
        fi
    fi

    if test "$neon_got_library" = "no"; then 
        AC_MSG_ERROR(could not find neon)
    fi

    AC_SUBST(NEON_LIBS)
])


AC_DEFUN([DAV_DEBUG],[

    AC_ARG_ENABLE(debug,
        [  --enable-debug          enable debug output, don't display credentials
  --enable-debug=secrets  enable debug output including credentials],
        [dav_debug="${enableval}"], [dav_debug="no"]
    )

    if test "$dav_debug" = "yes" -o "$dav_debug" = "secrets" ; then
        AC_DEFINE_UNQUOTED(DEBUG, 1, [Enable debug output, but not credentials.])
        CPPFLAGS="-g $CPPFLAGS"
    fi

    if test "$dav_debug" = "secrets"; then
        AC_DEFINE_UNQUOTED(DEBUG_SECRETS, 1, [Show credentials in debug output too.])
    fi
])


AC_DEFUN([DAV_LFS],[

    if test "$ne_LFS_message" = "LFS is supported by neon"; then
        AC_SYS_LARGEFILE
    fi

    if test "$ac_cv_sys_file_offset_bits" = "64"; then
        dav_lfs=yes
    else
        dav_lfs=no
    fi
])
